<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Attendance;
use Rats\Zkteco\Lib\ZKTeco;
use Illuminate\Console\Command;
use App\Models\AttendanceSetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class AttendanceCreate extends Command
{
    protected $signature = 'app:attendance-create';

    protected $description = 'Command description';

    public function handle()
    {
        try {
            $this->Attendance();
        } catch (\Exception $e) {
            Log::error('Error: ' . $e->getMessage());
        }
    }

    public function Attendance()
    {
        DB::beginTransaction();

        try {
            $setting = AttendanceSetting::first();
            $entryTimeStart = $setting->entry_start_time;
            $entryTimeEnd = $setting->entry_end_time;
            $exitTimeStart = $setting->exit_start_time;
            $exitTimeEnd = $setting->exit_end_time;

            $zk = new ZKTeco('192.168.0.173', 4370);
            $zk->connect();
            $zk->enableDevice();
            $zk->serialNumber();
            $attendances = $zk->getAttendance();
            $currentDate = now()->toDateString();

            $filteredAttendances = array_filter($attendances, fn($attendance) => explode(' ', $attendance['timestamp'])[0] == $currentDate);

            $users = User::select('id', 'fingerprint_id')->get();
            foreach ($users as $user) {
                $existingAttendance = Attendance::where('user_id', $user->id)
                    ->where('fingerprint_id', $user->fingerprint_id)
                    ->whereDate('date', $currentDate)
                    ->first();

                if (!$existingAttendance && !empty($user->fingerprint_id)) {
                    $data = new Attendance();
                    $data->user_id = $user->id;
                    $data->fingerprint_id = $user->fingerprint_id;
                    $data->date = now()->format('Y-m-d');
                    $data->entry_status = 0;
                    $data->status = 0;
                    $data->save();

                    DB::connection('mysql_live')->table('attendances')->insert([
                        'user_id' => $user->id,
                        'fingerprint_id' => $user->fingerprint_id,
                        'date' => now()->format('Y-m-d'),
                        'entry_status' => 0,
                        'status' => 0,
                    ]);
                }
            }

            foreach ($filteredAttendances as $attendance) {
                $user = User::where('fingerprint_id', $attendance['id'])->first();
                if ($user) {
                    $existingAttendance = Attendance::where('user_id', $user->id)
                        ->where('fingerprint_id', $attendance['id'])
                        ->whereDate('date', $currentDate)
                        ->first();

                    if ($existingAttendance && $existingAttendance->entry_status == 0) {
                        $attendanceTime = Carbon::parse($attendance['timestamp']);

                        if ($attendanceTime->between($entryTimeStart, $entryTimeEnd)) {
                            $existingAttendance->entry_status = 1;
                            $existingAttendance->entry_time = $attendanceTime->format('H:i:s');
                            $existingAttendance->status = 1;
                            $existingAttendance->save();

                            DB::connection('mysql_live')->table('attendances')->updateOrInsert(
                                [
                                    'user_id' => $user->id,
                                    'fingerprint_id' => $attendance['id'],
                                    'date' => now()->format('Y-m-d'),
                                ],
                                [
                                    'entry_time' => $attendanceTime->format('H:i:s'),
                                    'entry_status' => 1,
                                    'status' => 1,
                                ]
                            );
                        }

                        if ($attendanceTime->between($exitTimeStart, $exitTimeEnd)) {
                            $existingAttendance->exit_time = $attendanceTime->format('H:i:s');
                            $existingAttendance->exit_status = 1;
                            $existingAttendance->save();

                            DB::connection('mysql_live')->table('attendances')->updateOrInsert(
                                [
                                    'user_id' => $user->id,
                                    'fingerprint_id' => $attendance['id'],
                                    'date' => now()->format('Y-m-d'),
                                ],
                                [
                                    'exit_time' => $attendanceTime->format('H:i:s'),
                                    'exit_status' => 1,
                                    'status' => 1,
                                ]
                            );
                        }
                    }
                }
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
