<?php

namespace App\Http\Controllers\BackEnd\Department;

use App\Models\Subject;
use App\Models\FeeSetup;
use App\Models\FeeAssign;
use App\Models\SessionSetup;
use Illuminate\Http\Request;
use App\Models\SubjectAssign;
use App\Models\FeeAssignDetail;
use App\Models\BackEnd\Department;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;

class DepartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('departments')
                        ->whereNull('deleted_at')
                        ->orderBy('id', 'asc');

                return Datatables::of($data)
                    ->addColumn('status', function ($data) {
                            $button = '<label class="switch">';
                            $button .= ' <input type="checkbox" class="changeStatus" id="customSwitch' . $data->id . '" getId="' . $data->id . '" name="status"';

                            if ($data->status == 1) {
                                $button .= "checked";
                            }
                            $button .= ' ><span class="slider round"></span>';
                            $button .= '</label>';
                            return $button;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('class.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('class.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['status', 'action'])
                    ->toJson();
            }
            return view('backend.department.index');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.department.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'department_name' => 'required|string|unique:departments,department_name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

        try {
            $data = new Department();
            $data->department_name = $request->department_name;
            $data->status = $request->status;
            $data->created_by = 1;
            $data->save();

            return response()->json([
                'success' => true,
                'message' => 'Class created successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Department::findOrFail($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'department_name' => 'required|string|unique:departments,department_name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data = Department::findOrFail($id);
            $data->department_name = $request->department_name;
            $data->status = $request->status;
            $data->updated_by = 1;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Class updated successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $data = Department::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Class deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Class delete failed',
            ]);
        }
    }
    public function StatusChange(Request $request)
    {
        $data = Department::findOrFail($request->id);
        $data->status = $data->status == 1 ? 0 : 1;
        $data->update();

        if ($data->status == 1) {
            return response()->json([
                'success' => true,
                'message' => 'Status activated successfully',
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Status inactivated successfully',
            ]);
        }
    }

    public function subject(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('subjects')
                        ->whereNull('deleted_at')
                        ->orderBy('id', 'desc');

                return Datatables::of($data)
                    ->addColumn('status', function ($data) {
                            $button = '<label class="switch">';
                            $button .= ' <input type="checkbox" class="changeStatus" id="customSwitch' . $data->id . '" getId="' . $data->id . '" name="status"';

                            if ($data->status == 1) {
                                $button .= "checked";
                            }
                            $button .= ' ><span class="slider round"></span>';
                            $button .= '</label>';
                            return $button;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('subject.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('subject.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['status', 'action'])
                    ->toJson();
            }
            return view('backend.department.subject');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function subjectcreate()
    {
        return view('backend.department.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function subjectstore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:subjects,name,NULL,id,deleted_at,NULL',
                'code' => 'required|string|unique:subjects,code,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

        try {
            $data = new Subject();
            $data->name = $request->name;
            $data->code = $request->code;
            $data->status = 1;
            $data->created_by = 1;
            $data->save();

            return response()->json([
                'success' => true,
                'message' => 'Subject created successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectedit($id)
    {
        $data = Subject::findOrFail($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectupdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:subjects,name,' . $id . ',id,deleted_at,NULL',
            'code' => 'required|string|unique:subjects,code,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $subject = Subject::findOrFail($id);
            $subject->name = $request->name;
            $subject->code = $request->code;
            $subject->status = $request->status;
            $subject->updated_by = 1;
            $subject->save();

            return response()->json([
                'success' => true,
                'message' => 'Subject updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectdestroy($id)
    {
        try {
            $data = Subject::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Subject deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Subject delete failed',
            ]);
        }
    }
    public function SubjectStatusChange(Request $request)
    {
        $data = Subject::findOrFail($request->id);
        $data->status = $data->status == 1 ? 0 : 1;
        $data->update();

        if ($data->status == 1) {
            return response()->json([
                'success' => true,
                'message' => 'Status activated successfully',
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Status inactivated successfully',
            ]);
        }
    }

    public function feesindex(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('fee_setups')
                        ->where('type', 1)
                        ->whereNull('deleted_at')
                        ->orderBy('id', 'desc');

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('fees.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('fees.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';


                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('backend.fees.index');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function holtelfees(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('fee_setups')
                        ->where('type', 2)
                        ->whereNull('deleted_at')
                        ->orderBy('id', 'desc');

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('fees.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('fees.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';


                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('backend.fees.hostel_fees');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function feesstore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:fee_setups,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

        try {
            $data = new FeeSetup();
            $data->name = $request->name;
            $data->type = $request->type;
            $data->created_by = Auth::user()->id;
            $data->save();

            return response()->json([
                'success' => true,
                'message' => 'Fee created successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feesedit($id)
    {
        $data = FeeSetup::findOrFail($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feesupdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:fee_setups,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data = FeeSetup::findOrFail($id);
            $data->name = $request->name;
            $data->created_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Fees updated successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feesdestroy($id)
    {
        try {
            $data = FeeSetup::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Fees deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Fees delete failed',
            ]);
        }
    }

    public function feesStatusChange(Request $request)
    {
        $data = FeeSetup::findOrFail($request->id);
        $data->status = $data->status == 1 ? 0 : 1;
        $data->update();

        if ($data->status == 1) {
            return response()->json([
                'success' => true,
                'message' => 'Status activated successfully',
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Status inactivated successfully',
            ]);
        }
    }


    public function section(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('session_setups')
                        ->whereNull('deleted_at')
                        ->orderBy('id', 'desc');

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('section.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('section.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';


                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('backend.fees.section');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function sectioncreate()
    {
        return view('backend.department.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function sectionstore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:session_setups,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

        try {
            $data = new SessionSetup();
            $data->name = $request->name;
            $data->created_by = Auth::user()->id;
            $data->save();

            return response()->json([
                'success' => true,
                'message' => 'Session created successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function sectionedit($id)
    {
        $data = SessionSetup::findOrFail($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function sectionupdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:session_setups,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data = SessionSetup::findOrFail($id);
            $data->name = $request->name;
            $data->created_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Session updated successfully',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function sectiondestroy($id)
    {
        try {
            $data = SessionSetup::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Session deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Session delete failed',
            ]);
        }
    }

    public function sectionStatusChange(Request $request)
    {
        $data = SessionSetup::findOrFail($request->id);
        $data->status = $data->status == 1 ? 0 : 1;
        $data->update();

        if ($data->status == 1) {
            return response()->json([
                'success' => true,
                'message' => 'Session activated successfully',
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Session inactivated successfully',
            ]);
        }
    }

    public function feeassign(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = FeeAssign::with('class:id,department_name','section:id,name')->where('type', 1)->get();


            return Datatables::of($data)

                ->addColumn('class', function ($data) {
                    $department = $data->class->department_name ?? '--';
                    return $department;
                })

                ->addColumn('section', function ($data) {
                    $section = $data->section->name ?? '--';
                    return $section;
                })

                ->addColumn('action', function ($data) {
                    $edit = '<a id="details" href="' . route('feeassign.edit', $data->id) . '" class="btn btn-sm btn-info edit" title="Edit"><i class="fa fa-edit"></i></a>';

                    $show = '<a id="details" href="' . route('feeassign.show', $data->id) . '" class="btn btn-sm btn-primary show ml-1" title="Details"><i class="fa fa-eye"></i></a>';
                    return $edit . $show;
                })

                ->addIndexColumn()
                ->rawColumns(['section','class','action'])
                ->toJson();
            }
         return view('backend.fees.fee_assign');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function hostelfeeassign(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = FeeAssign::with('class:id,department_name','section:id,name')->where('type', 2)->get();

            return Datatables::of($data)

                ->addColumn('class', function ($data) {
                    $department = $data->class->department_name ?? '--';
                    return $department;
                })

                ->addColumn('section', function ($data) {
                    $section = $data->section->name ?? '--';
                    return $section;
                })

                ->addColumn('action', function ($data) {
                    $edit = '<a id="details" href="' . route('hostel.feeassign.edit', $data->id) . '" class="btn btn-sm btn-info edit" title="Edit"><i class="fa fa-edit"></i></a>';

                    $show = '<a id="details" href="' . route('hostel.feeassign.show', $data->id) . '" class="btn btn-sm btn-primary show ml-1" title="Details"><i class="fa fa-eye"></i></a>';
                    return $edit . $show;
                })

                ->addIndexColumn()
                ->rawColumns(['section','class','action'])
                ->toJson();
            }
         return view('backend.fees.hostel_fee_assign');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function hostelfeeassigncreate()
    {
        $fees = FeeSetup::where('type', 2)->get();
        $class = Department::where('status', 1)->get();
        $sections = SessionSetup::all();
        return view('backend.fees.hostel_fee_create', compact('fees', 'class', 'sections'));
    }

    public function hostelfeeassigntabletemp(Request $request)
    {
        $validatedData = $request->validate([
            'section_id' => 'required',
            'class_id' => 'required',
            'month_for' => 'required',
            'after_month' => 'required',
            'fee_name' => 'array',
            'fee_name.*' => 'required',
        ]);

        $data = [
            'type' => $validatedData['type'],
            'section_id' => $validatedData['section_id'],
            'class_id' => $validatedData['class_id'],
            'month_for' => $validatedData['month_for'],
            'after_month' => $validatedData['after_month'],
            'selected_fees' => $validatedData['fee_name'] ?? [],
        ];

        $class = Department::findOrFail($data['class_id']);
        $section = SessionSetup::findOrFail($data['section_id']);
        $fees = FeeSetup::whereIn('id', $data['selected_fees'])->get();

        return view('backend.fees.fee_assign_table', compact('data','section','class','fees'));
    }

    public function feeassigncreate()
    {
        $fees = FeeSetup::where('type', 1)->get();
        $class = Department::where('status', 1)->get();
        $sections = SessionSetup::all();
        return view('backend.fees.fee_assign_create', compact('fees', 'class', 'sections'));
    }

    public function feeassigntabletemp(Request $request)
    {
        $validatedData = $request->validate([
            'type' => 'required',
            'section_id' => 'required',
            'class_id' => 'required',
            'month_for' => 'required',
            'after_month' => 'required',
            'fee_name' => 'array',
            'fee_name.*' => 'required',
        ]);

        $data = [
            'type' => $validatedData['type'],
            'section_id' => $validatedData['section_id'],
            'class_id' => $validatedData['class_id'],
            'month_for' => $validatedData['month_for'],
            'after_month' => $validatedData['after_month'],
            'selected_fees' => $validatedData['fee_name'] ?? [],
        ];

        $class = Department::findOrFail($data['class_id']);
        $section = SessionSetup::findOrFail($data['section_id']);
        $fees = FeeSetup::whereIn('id', $data['selected_fees'])->get();
        return view('backend.fees.fee_assign_table', compact('data','section','class','fees'));
    }

    // public function feeassigntable()
    // {
    //     $fees = FeeSetup::all();
    //     $class = Department::where('status', 1)->get();
    //     $sections = SessionSetup::all();
    //     return view('backend.fees.fee_assign_table', compact('fees', 'class', 'sections'));
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

     public function feeassignstore(Request $request)
     {
         $messages = [
             'amount.required' => 'Enter amount',
         ];

         $this->validate($request, [
             'amount' => 'required|array',
         ], $messages);

         DB::beginTransaction();

         try {
             $assign = new FeeAssign();
             $assign->section_id = $request->section_id;
             $assign->class_id = $request->class_id;
             $assign->type = $request->type;
             $assign->created_by = Auth::user()->id;
             $assign->save();

            foreach ($request->month as $monthIndex => $month) {
                foreach ($request->fee_id[$monthIndex] as $key => $value) {
                    $assignDetails = new FeeAssignDetail();
                    $assignDetails->type = $assign->type;
                    $assignDetails->fee_assign_id = $assign->id;
                    $assignDetails->fee_id = $value;
                    $assignDetails->month = $month;
                    $assignDetails->amount = $request->amount[$monthIndex][$key];
                    $assignDetails->created_by = Auth::user()->id;
                    $assignDetails->save();
                }
            }

             DB::commit();
             return redirect()->route('fee.assign')->with('success', 'Fees assigned successfully');

         } catch (\Exception $exception) {
             DB::rollBack();
             return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
         }
     }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function feeassignshow($id)
    {
        $data = FeeAssign::with('class:id,department_name','section:id,name')->findOrFail($id);
        $details = FeeAssignDetail::with('fees')->where('fee_assign_id', $id)->get()->groupBy('month');
        return view('backend.fees.assign_details', compact('data','details'));
    }

    public function hostelfeeassignshow($id)
    {
        $data = FeeAssign::with('class:id,department_name','section:id,name')->findOrFail($id);
        $details = FeeAssignDetail::with('fees')->where('fee_assign_id', $id)->get()->groupBy('month');
        return view('backend.fees.hostel_assign_details', compact('data','details'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feeassignedit($id)
    {
        $data = FeeAssign::with('class:id,department_name','section:id,name')->findOrFail($id);
        $details = FeeAssignDetail::with('fees')->where('fee_assign_id', $id)->get()->groupBy('month');
        return view('backend.fees.assign_edit', compact('data','details'));
    }

    public function hostelfeeassignedit($id)
    {
        $data = FeeAssign::with('class:id,department_name','section:id,name')->findOrFail($id);
        $details = FeeAssignDetail::with('fees')->where('fee_assign_id', $id)->get()->groupBy('month');
        return view('backend.fees.hostel_fee_edit', compact('data','details'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feeassignupdate(Request $request, $id)
    {
        $messages = array(
            // 'join_date.required' => 'তারিখ লিখুন',
            'name.required' => 'নাম লিখুন',
            // 'father_name.required' => 'পিতার লিখুন',
            'department_id.required' => 'ক্লাস নির্বাচন করুন',
            'student_type.required' => 'ছাত্রের ধরন নির্বাচন করুন',
            // 'admission_fee.required' => 'ভর্তি ফি লিখুন',
            // 'monthly_fee.required' => 'মাসিক বেতন লিখুন',
            // 'village.required' => 'গ্রাম লিখুন',
            // 'post_office.required' => 'ডাকঘর লিখুন',
            // 'police_station.required' => 'থানা লিখুন',
            // 'district.required' => 'জেলা লিখুন',
            // 'gurdian_name.required' => 'অভিভাবকের নাম লিখুন',
            // 'relation.required' => 'সম্পর্ক লিখুন',
            'gurdian_mobile.required' => 'মোবাইল নং লিখুন',
            // 'gurdian_address.required' => 'অভিভাবকের ঠিকানা লিখুন',
        );

        $this->validate($request, array(
            // 'join_date' => 'required',
            'name' => 'required',
            // 'father_name' => 'required',
            'department_id' => 'required',
            // 'monthly_fee' => 'required',
            // 'gurdian_name' => 'required',
            'gurdian_mobile' => 'required',
            // 'relation' => 'required',
            // 'gurdian_address' => 'required',
        ), $messages);

        DB::beginTransaction();

        try {

            $data = student::findOrFail($id);

            $image = $request->file('image');
            if($request->hasfile('image')) {
                $filename = time() . $image->getClientOriginalName();
                $image->move(public_path('/backend/img/student/'), $filename);
                $data->image = $filename;
            }else{
                $data->image = $request->current_image;
            }

            $data->form_no            = $request->form_no;
            $data->join_date          = Carbon::parse($request->join_date)->format('Y-m-d');;
            $data->name               = $request->name;
            $data->father_name        = $request->father_name;
            $data->mother_name        = $request->mother_name;
            $data->birth_date         = Carbon::parse($request->birth_date)->format('Y-m-d');
            $data->department_id      = $request->department_id;
            $data->student_type       = $request->student_type;
            $data->monthly_fee        = $request->monthly_fee;
            $data->admission_fee      = $request->admission_fee;
            $data->meal_cost          = $request->meal_cost;
            $data->village            = $request->village;
            $data->post_office        = $request->post_office;
            $data->police_station     = $request->police_station;
            $data->district           = $request->district;
            $data->gurdian_name       = $request->gurdian_name;
            $data->relation           = $request->relation;
            $data->gurdian_mobile     = $request->gurdian_mobile;
            $data->gurdian_address    = $request->gurdian_address;
            $data->update();

            $user = User::where('id', $data->user_id)->first();
            $user->name  = $request->name;
            $user->register_no = $request->register_no;
            $user->type = 3;
            $user->password  = Hash::make('student');
            $user->update();

            $studentHistory = new StudentHistory();
            $studentHistory->student_id       = $data->id;
            $studentHistory->register_no      = $data->register_no;
            $studentHistory->form_no          = $data->form_no;
            $studentHistory->name             = $request->name;
            $studentHistory->join_date        = Carbon::parse($request->join_date)->format('Y-m-d');
            $studentHistory->student_type     = $request->student_type;
            $studentHistory->monthly_fee      = $request->monthly_fee;
            $studentHistory->admission_fee    = $request->admission_fee;
            $studentHistory->meal_cost        = $request->meal_cost;
            $studentHistory->department_id    = $request->department_id;
            $studentHistory->gurdian_mobile   = $request->gurdian_mobile;
            $studentHistory->created_by       = Auth::user()->name;
            $studentHistory->save();

            $student = Student::findOrFail($data->id);
            $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
            $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

            $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->join_date)->format('d/m/Y'));

            $admissionFee = str_replace($bn_numbers, $en_numbers, $student->admission_fee);
            $monthlyFee = str_replace($bn_numbers, $en_numbers, $student->monthly_fee);
            $mealCost = str_replace($bn_numbers, $en_numbers, $student->meal_cost);

            $total = $admissionFee + $monthlyFee + $mealCost;
            $totalCost = str_replace($en_numbers, $bn_numbers, $total);
            $phone = str_replace($bn_numbers, $en_numbers, $request->gurdian_mobile);
            $class = $student->departments->department_name;

            if($student->student_type == 1){
                $type = 'আবাসিক';
            }elseif($student->student_type == 2){
                $type = 'অনাবাসিক';
            }

            $msg = "দারুল উলুম সরকারপাড়া মাদরাসা, তারিখ : $date, নাম : $student->name, ক্লাস : $class, ছাত্রের ধরন : $type, মোবাইল : $student->gurdian_mobile, ভর্তি ফি :  $student->admission_fee,   মাসিক বেতন : $student->monthly_fee, মাসিক খাবার, $student->meal_cost. সর্বমোট : $totalCost, আপনার ভর্তি সফলভাবে আপডেট করা হয়েছে";

            $this->SendSms($phone, $msg);

            DB::commit();

            return redirect()->route('student.show', $data->id)
                ->with('success', 'Student updated successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function feeassigndestroy($id)
    {
        try{
            $data = FeeAssign::findOrFail($id);
            $data->delete();
            // if($data){
            //     $user = User::where('user_id', $id)->first();
            //     $user->delete();
            //     $data->delete();
            // }

            return response()->json([
                'success' => true,
                'message' => 'Student deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Student delete failed',
            ]);
        }
    }

    public function subjectassign(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = SubjectAssign::with('subjects','class')->groupBy('class_id')->get();

                return Datatables::of($data)

                    ->addColumn('class', function ($data) {
                            return $data->class->department_name;
                    })

                    ->addColumn('subject', function ($data) {
                        $subjectNames = $data->subjects->pluck('name', 'code')->toArray();
                        $formattedSubjects = [];

                        foreach ($subjectNames as $code => $name) {
                            $formattedSubjects[] = "{$name} - {$code}";
                        }

                        return implode(', ', $formattedSubjects);
                    })


                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('subject.assign.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('subject.assign.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['class', 'action','subject'])
                    ->toJson();
            }
            $class = Department::where('status', 1)->get();
            $subjects = Subject::where('status', 1)->get();
            return view('backend.department.subject_assign', compact('class','subjects'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function subjectassignstore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'class_id' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                foreach($request->subject_id as $key => $subject) {
                    $subjectAssign = new SubjectAssign();
                    $subjectAssign->class_id = $request->class_id;
                    $subjectAssign->subject_id = $subject;
                    $subjectAssign->created_by = 1;
                    $subjectAssign->save();
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Data created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectassignedit($id)
    {
        $data = SubjectAssign::findOrFail($id);
        $subjectIds = SubjectAssign::where('class_id', $data->class_id)->pluck('subject_id')->toArray();

        return response()->json([
            'id' => $data->id,
            'class_id' => $data->class_id,
            'subject_id' => $subjectIds,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectassignupdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'class_id' => 'required',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {

            SubjectAssign::where('class_id', $id)->delete();
            foreach($request->subject_id as $key => $subject) {
                $subjectAssign = new SubjectAssign();
                $subjectAssign->class_id = $request->class_id;
                $subjectAssign->subject_id = $subject;
                $subjectAssign->created_by = 1;
                $subjectAssign->save();
            }

            return response()->json([
                'success' => true,
                'message' => 'Data updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function subjectassigndestroy($id)
    {
        try {
            $data = SubjectAssign::where('class_id', $id)->delete();
            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }

    public function extrafeeassign(Request $request)
    {
        try {

            if ($request->ajax()) {

                $data = FeeAssign::with('class:id,department_name')->where('type', 3)->get();

                return Datatables::of($data)

                    ->addColumn('class', function ($data) {
                        $department = $data->class->department_name ?? '--';
                        return $department;
                    })

                    ->addColumn('month', function ($data) {
                        $monthData = DB::table('fee_assign_details')->where('fee_assign_id', $data->id)->first();
                        return $monthData && $monthData->month ? \Carbon\Carbon::parse($monthData->month)->format('F, Y') : 'N/A';
                    })

                    ->addColumn('fee', function ($data) {
                        $fee = FeeAssignDetail::with('fees')->where('fee_assign_id', $data->id)->first();
                        return $fee->fees->name ?? '';
                    })

                    ->addColumn('amount', function ($data) {
                        $amount = DB::table('fee_assign_details')->where('fee_assign_id', $data->id)->first();
                        return $amount->amount;
                    })

                    ->addColumn('action', function ($data) {
                        $edit = '<a id="edit" href="' . route('extra.fee.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete ml-1" data-remote=" ' . route('extra.fee.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['month','class','action','fee','amount'])
                    ->toJson();
                }
                $fees = FeeSetup::where('type', 3)->get();
                $class = Department::where('status', 1)->get();
                $sections = SessionSetup::all();

                return view('backend.fees.extra_fee_assign', compact('class', 'sections','fees'));

            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }

    }

    public function extrafeestore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'amount' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }
        DB::beginTransaction();

        try {
             $assign = new FeeAssign();
             $assign->class_id = $request->class_id;
             $assign->type = $request->type;
             $assign->created_by = Auth::user()->id;
             $assign->save();

             $assignDetails = new FeeAssignDetail();
             $assignDetails->type = $assign->type;
             $assignDetails->fee_assign_id = $assign->id;
             $assignDetails->fee_id = $request->fee_id;
             $assignDetails->month = \Carbon\Carbon::parse($request->month)->format('Y-m');
             $assignDetails->amount = $request->amount;
             $assignDetails->created_by = Auth::user()->id;
             $assignDetails->save();

             DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Data created successfully',
            ]);

        } catch (\Exception $exception) {
            DB::rollBack();
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function extrafeeedit($id)
    {
        $data = FeeAssign::findOrFail($id);
        $fee = FeeAssignDetail::where('fee_assign_id', $id)->first();
        $month = \Carbon\Carbon::parse($fee->month)->format('M-Y');

        return response()->json([
            'id' => $data->id,
            'class_id' => $data->class_id,
            'fee_id' => $fee->fee_id,
            'month' => $month,
            'amount' => $fee->amount,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function extrafeeupdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'amount' => 'required',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        DB::beginTransaction();

        try {
             $assign = FeeAssign::findOrFail($id);
             $assign->class_id = $request->class_id;
             $assign->type = 3;
             $assign->created_by = Auth::user()->id;
             $assign->save();

             $assignDetails = FeeAssignDetail::where('fee_assign_id', $id)->first();
             $assignDetails->type = $assign->type;
             $assignDetails->fee_assign_id = $assign->id;
             $assignDetails->fee_id = $request->fee_id;
             $assignDetails->month = \Carbon\Carbon::parse($request->month)->format('Y-m');
             $assignDetails->amount = $request->amount;
             $assignDetails->created_by = Auth::user()->id;
             $assignDetails->save();

             DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Data updated successfully',
            ]);

        } catch (\Exception $exception) {
            DB::rollBack();
            return response()->json([
                'success' => true,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function extrafeedestroy($id)
    {
        try {
            $data = FeeAssign::findOrFail($id);
            FeeAssignDetail::where('fee_assign_id', $id)->delete();
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Class deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Class delete failed',
            ]);
        }
    }


}
