<?php

namespace App\Http\Controllers\BackEnd;

use Carbon\Carbon;
use App\Traits\SmsTrait;
use App\Traits\DeleteTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\BackEnd\GeneralFund;
use App\Models\BackEnd\Transaction;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;

class GeneralFundController extends Controller
{
    use SmsTrait;
    use DeleteTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = DB::table('general_funds')->whereNull('deleted_at')->orderBy('id', 'DESC');

            return Datatables::of($data)

                ->addColumn('action', function ($data) {

                        $result = '';

                        $details = '<li><a class="dropdown-item" href="' . route('general-fund.show', $data->id) . ' " ><i class="fa fa-eye" ></i> Details</a></li>';

                        $edit = '<li><a class="dropdown-item" href="' . route('general-fund.edit', $data->id) . ' "><i class="fa fa-edit"></i> Edit</a></li>';

                        $delete = '<li><a class="dropdown-item btn-delete" href="#" data-remote=" ' . route('general-fund.destroy', $data->id) . ' "><i class="fa fa-trash"></i> Delete</a></li>';

                        $result = $details. $edit. $delete;

                        return '<div class="btn-group open">
                        <a class="badge badge-primary dropdown-toggle" href="#" role="button"  data-toggle="dropdown">Actions<i class="ik ik-chevron-down mr-0 align-middle"></i></a>
                        <ul class="dropdown-menu" role="menu" style="width:auto; min-width:auto;">'.$result.'
                        </ul>
                    </div>';
                })

                ->addIndexColumn()
                ->rawColumns(['action'])
                ->toJson();
            }
         return view('backend.general_fund.index');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $id = GeneralFund::count();
        return view('backend.general_fund.create', compact('id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $messages = array(
            'receipt_no.required' => 'Enter receipt no',
            'name.required' => 'Enter student name',
            'date.required' => 'Enter date',
            'amount.required' => 'Enter amount',
            'mobile.required' => 'Enter mobile number',
            'received_purpose.required' => 'Enter on account of',
            // 'address.required' => 'Write address',
        );

        $this->validate($request, array(
            'receipt_no' => 'required',
            'date' => 'required',
            'name' => 'required',
            'amount' => 'required',
            'mobile' => 'required',
            'received_purpose' => 'required',
            // 'address' => 'required',
        ), $messages);

        DB::beginTransaction();

        // try {

            $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
            $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

            $data = new GeneralFund();
            $data->receipt_no         = $request->receipt_no ;
            $data->date               = Carbon::parse($request->date)->format('Y-m-d');
            $data->name               = $request->name;
            $data->mobile             = $request->mobile;
            $data->address            = $request->address;
            $data->amount             = $request->amount;
            $data->in_word            = $request->in_word;
            $data->type               = 1;
            $data->received_purpose   = $request->received_purpose;
            $data->note               = $request->note;
            $data->save();

            $transaction = new Transaction();
            $transaction->general_fund_id       = $data->id;
            $transaction->date                  = Carbon::parse($request->date)->format('Y-m-d');
            $transaction->transaction_purpose   = $request->received_purpose;
            $transaction->transaction_type      = 1;
            $transaction->payment_type          = 6;
            $transaction->amount                = str_replace($bn_numbers, $en_numbers, $request->amount);
            $transaction->save();

            $user = GeneralFund::findOrFail($data->id);
            $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($user->date)->format('d/m/Y'));
            $phone = str_replace($bn_numbers, $en_numbers, $user->mobile);
            $msg = "দারুল উলুম সরকারপাড়া মাদরাসা, তারিখ : $date, নাম : $user->name, মোবাইল : $user->mobile, টাকার পরিমাণ : $user->amount , আপনার টাকা গ্রহণ করা হয়েছে, জাযাকাল্লাহ ।";

            $this->SendSms($phone, $msg);

            DB::commit();

            return redirect()->route('general-fund.show', $data->id)
                ->with('success', 'Money received successfully');
        // } catch (\Exception $exception) {
            DB::rollBack();
        //     return redirect()->back()->with('error', $exception->getMessage());
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = GeneralFund::findOrFail($id);
        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));
        return view('backend.general_fund.show', compact('data', 'receiptNo','date'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = GeneralFund::findOrFail($id);
        $date =  Carbon::parse($data->date)->format('d M Y');
        return view('backend.general_fund.edit', compact('data','date'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $messages = array(
            'receipt_no.required' => 'Enter receipt no',
            'name.required' => 'Enter student name',
            'date.required' => 'Enter date',
            'amount.required' => 'Enter amount',
            'mobile.required' => 'Enter mobile number',
            'received_purpose.required' => 'Enter on account of',
        );

        $this->validate($request, array(
            'receipt_no' => 'required',
            'date' => 'required',
            'name' => 'required',
            'amount' => 'required',
            'mobile' => 'required',
            'received_purpose' => 'required',
        ), $messages);

        DB::beginTransaction();

        try {
            $data = GeneralFund::findOrFail($id);
            $data->receipt_no         = $request->receipt_no ;
            $data->date               = Carbon::parse($request->date)->format('Y-m-d');
            $data->name               = $request->name;
            $data->mobile             = $request->mobile;
            $data->address            = $request->address;
            $data->amount             = $request->amount;
            $data->in_word            = $request->in_word;
            $data->type               = 1;
            $data->received_purpose   = $request->received_purpose;
            $data->note               = $request->note;
            $data->update();

            $transaction = Transaction::where('general_fund_id', $id)->first();
            $transaction->general_fund_id       = $data->id;
            $transaction->date                  = Carbon::parse($request->date)->format('Y-m-d');
            $transaction->transaction_purpose   = $request->received_purpose;
            $transaction->transaction_type      = 1;
            $transaction->amount                = $request->amount;
            $transaction->update();

            $user = GeneralFund::findOrFail($data->id);
            $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
            $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

            $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($user->date)->format('d/m/Y'));

            $phone = str_replace($bn_numbers, $en_numbers, $user->mobile);

            $msg = "দারুল উলুম সরকারপাড়া মাদরাসা, তারিখ : $date, নাম : $user->name, মোবাইল : $user->mobile, টাকার পরিমাণ : $user->amount , আপনার টাকা আপডেট করা হয়েছে, জাযাকাল্লাহ ।";

            $this->SendSms($phone, $msg);

            DB::commit();

            return redirect()->route('general-fund.show', $id)
                ->with('success', 'Money received updated successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $data = GeneralFund::findOrFail($id);
            if($data){
                $transaction = Transaction::where('general_fund_id', $id)->first();
                $transaction->delete();
                $data->delete();
            }
            return response()->json([
                'success' => true,
                'message' => 'General fund deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'General fund delete failed',
            ]);
        }
    }
    public function print($id)
    {
        $data = GeneralFund::findOrFail($id);

        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));
        return view('backend.general_fund.print', compact('data','receiptNo','date'));
    }
}
