<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Fund;
use App\Models\User;
use App\Models\Leave;
use App\Mail\SendEmail;
use App\Models\Setting;
use App\Models\Subject;
use App\Models\Teacher;
use App\Traits\SmsTrait;
use App\Models\SmsStatus;
use App\Models\FundDetail;
use App\Models\StudentExam;
use App\Traits\DeleteTrait;
use App\Models\SessionSetup;
use App\Models\StudentClass;
use Illuminate\Http\Request;
use App\Models\InvoiceDesign;
use App\Models\TeacherAssign;
use App\Traits\DateFormatter;
use App\Models\StudentPayment;
use App\Models\StudentSession;
use App\Models\TeacherHistory;
use App\Models\BackEnd\Department;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\ResponsibilityAssign;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Models\TeacherBookDistribute;
use App\Models\TeacherResponsibility;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class TeacherController extends Controller
{
    use SmsTrait;
    use DeleteTrait;
    use DateFormatter;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

        if($request->ajax()) {

            $data = DB::table('teachers')->whereNull('deleted_at')->whereNull('discharge_status')->orderByDesc('id')->get();

            return Datatables::of($data)

             ->addColumn('action', function ($data) {
    $details = '<a href="' . route('teacher.show', $data->id) . '" class="btn btn-sm btn-info" title="Details"><i class="fa fa-eye"></i> Details</a> ';
    $edit    = '<a href="' . route('teacher.edit', $data->id) . '" class="btn btn-sm btn-success" title="Edit"><i class="fa fa-edit"></i> Edit</a> ';
    $idcard  = '<a href="' . route('teacher.idcard', $data->id) . '" class="btn btn-sm btn-primary" title="ID-Card"><i class="fas fa-file"></i> ID-Card</a> ';
    $bonus   = '<a href="' . route('teacher.bonus', $data->id) . '" class="btn btn-sm btn-warning" title="Bonus"><i class="fas fa-dollar-sign"></i> Bonus</a> ';

    $delete = '';
    if ($this->DeleteData()) {
        $delete = '<a href="#" data-remote="' . route('teacher.destroy', $data->id) . '" class="btn btn-sm btn-danger btn-delete" title="Delete"><i class="fa fa-trash"></i> Delete</a>';
    }

    return $details . $edit . $idcard . $bonus . $delete;
})



                ->addIndexColumn()
                ->rawColumns(['action'])
                ->toJson();
            }
         return view('dashboard.teachers.index');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $teacher = Teacher::count();
        return view('dashboard.teachers.create', compact('teacher'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();

        try {
            $user = new User();
            $user->name  = $request->name;
            $user->email = $request->email;
            $user->type = 2;
            $user->password  = Hash::make('123456');
            $user->show_pass  = 123456;
            $user->created_by  = Auth::user()->id;
            $user->save();

            $data = new Teacher();

            $certificate = [];

            if($request->hasfile('certificate')) {
                foreach($request->file('certificate') as $image) {
                $filename = time() . $image->getClientOriginalName();
                $image->move(public_path('/backend/img/teacher/'), $filename);
                $certificate[] = $filename;
             }
            }


            $card_photo = [];
                if($request->hasfile('card_photo')) {
                    foreach($request->file('card_photo') as $image) {
                    $filename = time() . $image->getClientOriginalName();
                    $image->move(public_path('/backend/img/teacher/'), $filename);
                    $card_photo[] = $filename;
                }
            }


            if ($request->file('image')) {
                $file = $request->file('image');
                $filename = time() . $file->getClientOriginalName();
                $file->move(public_path('/backend/img/teacher/'), $filename);
                $data->image = $filename;
            }


            $data->user_id       = $user->id;
            $data->reg_no       = $request->reg_no;
            $data->name          = $request->name;
            $data->join_date     = $this->formatAnyDateToYmd($request->join_date);;
            $data->gender        = $request->gender;
            $data->designation  = $request->designation;
            $data->salary       = $request->salary;
            $data->phone        = $request->phone;
            $data->email        = $request->email;
            $data->blood_group  = $request->blood_group;
            $data->status       = $request->status;
            $data->address      = $request->address;
            $data->description  = $request->description;
            $data->exam_name    = !empty($request->exam_name) ? json_encode($request->exam_name) : null;
            $data->passing_year = !empty($request->passing_year) ? json_encode($request->passing_year) : null;
            $data->certificate  = !empty($certificate) ? json_encode($certificate) : null;
            $data->card_name    = !empty($request->card_name) ? json_encode($request->card_name) : null;
            $data->card_no      = !empty($request->card_no) ? json_encode($request->card_no) : null;
            $data->card_photo   = !empty($card_photo) ? json_encode($card_photo) : null;
            $data->created_by   = 1;
            $data->save();

            $teacherHistory = new TeacherHistory();
            $teacherHistory->teacher_id       = $data->id;
            $teacherHistory->name             = $request->name;
            $teacherHistory->date             = $this->formatAnyDateToYmd($request->join_date);;
            $teacherHistory->salary           = $request->salary;
            $teacherHistory->designation      = $request->designation;
            $teacherHistory->created_by       = 1;
            $teacherHistory->save();

            $site = DB::table('settings')->first();
            $to = $data->phone;
            $text = ' অভিনন্দন ' . $site->name . ' ' . $data->name . ' পরিবারের নতুন সদস্য হিসেবে আপনাকে স্বাগত জানাই ';
            $status = optional(SmsStatus::first())->teacher_admission;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            DB::commit();

            return redirect()->route('teacher.index')
                ->with('success', 'Teacher created successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Teacher::findOrFail($id);
        $invoice =  InvoiceDesign::first();
        return view('dashboard.teachers.show', compact('data' , 'invoice'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Teacher::findOrFail($id);
        return view('dashboard.teachers.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        DB::beginTransaction();

        try {
            $data = Teacher::findOrfail($id);

            $card_photo = [];
            if($request->hasFile('card_photo')){
                foreach ($request->file('card_photo') as $image) {
                    $filename = time() . $image->getClientOriginalName();
                    $image->move(public_path('/backend/img/teacher/'), $filename);
                    $card_photo[] = $filename;
                   }
            }

            if($request->old_card_photo){
                foreach ($request->old_card_photo as $image) {
                    $card_photo[] = $image;
                }
            }

            $certificate = [];
            if($request->hasFile('certificate')){
                foreach ($request->file('certificate') as $image) {
                    $filename = time() . $image->getClientOriginalName();
                    $image->move(public_path('/backend/img/teacher/'), $filename);
                    $certificate[] = $filename;
                   }
            }

            if($request->old_certificate){
                foreach ($request->old_certificate as $image) {
                    $certificate[] = $image;
                }
            }

            if ($request->file('image')) {
                $file = $request->file('image');
                $filename = time() . $file->getClientOriginalName();
                $file->move(public_path('/backend/img/teacher/'), $filename);
                $data->image = $filename;
            }

            $data->reg_no       = $request->reg_no;
            $data->name         = $request->name;
            $data->join_date    =  $this->formatAnyDateToYmd($request->birth_date);;
            $data->gender       = $request->gender;
            $data->designation  = $request->designation;
            $data->salary       = $request->salary;
            $data->phone        = $request->phone;
            $data->email        = $request->email;
            $data->blood_group  = $request->blood_group;
            $data->status       = $request->status;
            $data->address      = $request->address;
            $data->description  = $request->description;
            $data->exam_name    = !empty($request->exam_name) ? json_encode($request->exam_name) : null;
            $data->passing_year = !empty($request->passing_year) ? json_encode($request->passing_year) : null;
            $data->certificate  = !empty($certificate) ? json_encode($certificate) : null;
            $data->card_name    = !empty($request->card_name) ? json_encode($request->card_name) : null;
            $data->card_no      = !empty($request->card_no) ? json_encode($request->card_no) : null;
            $data->card_photo   = !empty($card_photo) ? json_encode($card_photo) : null;
            $data->created_by   = 1;
            $data->update();

            $teacherHistory = TeacherHistory::where('teacher_id', $id)->first();
            $teacherHistory->teacher_id       = $request->teacher_id;
            $teacherHistory->name             = $request->name;
            $teacherHistory->date             = $this->formatAnyDateToYmd($request->birth_date);;
            $teacherHistory->salary           = $request->salary;
            $teacherHistory->designation      = $request->designation;
            $teacherHistory->updated_by       = Auth::user()->id;
            $teacherHistory->update();

            $user = User::where('id', $data->user_id)->first();
            $user->name = $request->name;
            $user->phone = $request->phone;
            $user->email  = $request->email;
            $user->created_by  = Auth::user()->id;
            $user->type = 2;
            $user->update();

            $site = DB::table('settings')->first();
            $to = $data->phone;
            $text =  ' অভিনন্দন '. $site->name . ' ' . $data->name . ' পরিবারের নতুন সদস্য হিসেবে আপনাকে স্বাগত জানাই ';

            $status = optional(SmsStatus::first())->teacher_admission;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            DB::commit();

            return redirect()->route('teacher.index')
                ->with('success', 'Teacher updated successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $data = Teacher::findOrFail($id);
            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'teacher_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'teachers') {
                    DB::table($table->TABLE_NAME)->where('teacher_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Teacher deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Teacher deleted failed',
            ]);
        }
    }

    public function StatusChange(Request $request)
    {
        $data = Teacher::findOrFail($request->id);
        $data->status = $data->status == 1 ? 0 : 1;
        $data->update();

        if ($data->status == 1) {
            return response()->json([
                'success' => true,
                'message' => 'Status activated successfully',
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Status inactivated successfully',
            ]);
        }
    }


    public function salary($id)
    {
        $data = Teacher::with('departments')->findOrFail($id);
        $banks = BankAccount::with('banks')->where('status', 1)->get();
        $mobilebanks = MobileBankingAccount::with('mobileBankings')->where('status', 1)->get();
        return view('backend.teachers.salary_pay.create', compact('data','banks','mobilebanks'));
    }

    public function salaryIncrement($id)
    {
        $data = Teacher::with('departments')->findOrFail($id);
        $banks = BankAccount::with('banks')->where('status', 1)->get();
        $mobilebanks = MobileBankingAccount::with('mobileBankings')->where('status', 1)->get();
        return view('backend.teachers.salary_increment.create', compact('data','banks','mobilebanks'));
    }

    public function TeacherHistory(Request $request, $id)
    {
        try {
            if ($request->ajax()) {

                $data = TeacherHistory::with('teachers','departments')->where('teacher_id', $id)->get();

                return Datatables::of($data)

                    ->addColumn('date', function ($data) {
                        $date = date('F d, Y',  strtotime($data->date));
                        return $date;
                    })

                    ->addColumn('department', function ($data) {
                        $department = $data->departments->department_name ?? '--';
                        return  $department;
                    })

                    ->addColumn('previousSalary', function ($data) {
                        $salary = $data->salary - $data->increment_amount;
                        return  number_format($salary, 2);
                    })

                    ->addColumn('incrementAmount', function ($data) {
                        $salary = $data->increment_amount;
                        return  number_format($salary, 2);
                    })

                    ->addColumn('currentSalary', function ($data) {
                        $salary = $data->salary ;
                        return  number_format($salary, 2);
                    })

                    ->addColumn('incrementReason', function ($data) {
                        $value = $data->increment_reason ?? '--' ;
                        return  $value;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['date','department','previousSalary','incrementAmount','currentSalary','incrementReason'])
                    ->toJson();
                }
                return view('backend.teachers.teacher.history');
            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
    }

    public function TeacherAssign(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = TeacherAssign::with('teacher','stuclass')->groupBy('class_id')->get();

                return Datatables::of($data)

                    ->addColumn('className', function ($data) {
                        return $data->stuclass->name;
                    })

                    ->addColumn('teacherName', function ($data) {
                        $teacherNames = $data->teacher->pluck('name', 'phone')->toArray();
                        $teachers = DB::table('teacher_assigns')->whereNull('deleted_at')->where('class_id', $data->class_id)->get();
                        $teacherNames = [];
                        foreach ($teachers as $key => $teacher) {
                            $name = DB::table('teachers')->where('id', $teacher->teacher_id)->select('id','name','phone')->first();
                            $teacherNames[] = $name->name . '-' . $name->phone;
                        }
                        return implode(', ', $teacherNames);
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('teacher.assign.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('teacher.assign.destroy', $data->class_id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['className', 'action','teacherName'])
                    ->toJson();
            }

            $class = StudentClass::all();
            $teachers = Teacher::whereNull('discharge_status')->select('id','name','phone')->get();
            $sections = StudentSession::all();

            return view('dashboard.teachers.teacher_assign', compact('class','teachers','sections'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function TeacherAssignStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'class_id' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                foreach($request->teacher_id as $key => $teacher) {
                    $teacherAssign = new TeacherAssign();
                    $teacherAssign->class_id = $request->class_id;
                    $teacherAssign->teacher_id = $teacher;
                    $teacherAssign->created_by = 1;
                    $teacherAssign->save();
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Teacher assigned successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function TeacherAssignEdit($id)
    {
        $data = TeacherAssign::findOrFail($id);
        $teacherIds = TeacherAssign::where('class_id', $data->class_id)->pluck('teacher_id')->toArray();
        return response()->json([
            'id' => $data->id,
            'class_id' => $data->class_id,
            'teacher_id' => $teacherIds,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function TeacherAssignUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'class_id' => 'required',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            TeacherAssign::where('class_id', $id)->delete();
            foreach($request->teacher_id as $key => $teacher) {
                $teacherAssign = new TeacherAssign();
                $teacherAssign->class_id = $request->class_id;
                $teacherAssign->teacher_id = $teacher;
                $teacherAssign->created_by = 1;
                $teacherAssign->save();
            }

            return response()->json([
                'success' => true,
                'message' => 'Data updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function TeacherAssignDestroy($id)
    {
        try {
            TeacherAssign::where('class_id', $id)->delete();

            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }

    public function TeacherLeave(Request $request)
    {
        try {

            if ($request->ajax()) {

                $data = Leave::with('teacher:id,name')->where('type', 1)->get();

                return Datatables::of($data)

                    ->addColumn('date', function ($data) {
                        $from = Carbon::parse($data->from_date)->format('d-M-Y') ?? '';
                        $to = Carbon::parse($data->to_date)->format('d-M-Y') ?? '';
                        return $from . '<br> '. $to ;
                    })

                    ->addColumn('teacher', function ($data) {
                        $name = isset($data->teacher) ? $data->teacher->name : '--';
                        $reg = isset($data->teacher) ? $data->teacher->reg_no : '--';
                        return $name . '<br>'. $reg ;
                    })

                    ->addColumn('givedBy', function ($data) {
                        return $data->users->name ?? ''; ;
                    })

                   ->addColumn('action', function ($data) {
    $details = '<a href="' . route('teacher.leave.show', $data->id) . '" class="btn btn-sm btn-info" title="Details"><i class="fa fa-eye"></i> Details</a> ';
    $edit    = '<a href="' . route('teacher.leave.edit', $data->id) . '" class="btn btn-sm btn-success" title="Edit"><i class="fa fa-edit"></i> Edit</a> ';
    $delete  = '<a href="#" data-remote="' . route('teacher.leave.destroy', $data->id) . '" class="btn btn-sm btn-danger btn-delete" title="Delete"><i class="fa fa-trash"></i> Delete</a>';

    return $details . $edit . $delete;
})


                    ->addIndexColumn()
                    ->rawColumns(['date','givedBy','teacher','action'])
                    ->toJson();
                }
                return view('dashboard.teachers.leaves.leave');
            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
    }

    public function TeacherLeaveCreate()
    {
        $teachers = Teacher::whereNull('discharge_status')->select('id','name','phone','reg_no')->get();
        return view('dashboard.teachers.leaves.leave_create', compact('teachers'));
    }

    public function TeacherLeaveStore(Request $request)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
            'from_date.required' => 'Enter from date',
            'to_date.required' => 'Enter to date',
        ];

        $request->validate([
            'teacher_id' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
        ], $messages);

        try {
            $from = Carbon::parse($request->from_date)->format('Y-m-d');
            $to = Carbon::parse($request->to_date)->format('Y-m-d');

            $exists = Leave::where('teacher_id', $request->teacher_id)
            ->where(function($query) use ($from, $to) {
                $query->whereBetween('from_date', [$from, $to])
                      ->orWhereBetween('to_date', [$from, $to])
                      ->orWhere(function($query) use ($from, $to) {
                          $query->where('from_date', '<=', $from)
                                ->where('to_date', '>=', $to);
                      });
            })
            ->exists();

            if($exists){
                return redirect()->back()->with('error', 'Leave for the selected dates has already been applied for.');
            }

            $data = new Leave();
            $data->teacher_id = $request->teacher_id;
            $data->from_date = $from;
            $data->to_date = $to;
            $data->days = $request->days;
            $data->type = 1;
            $data->note = $request->note;
            $data->created_by = Auth::user()->id;
            $data->save();

            $teacher = Teacher::findOrFail($request->teacher_id);
            $site = DB::table('settings')->first();
            $to = $teacher->phone;
            $text = $teacher->name . ', ' . $data->from_date . ' থেকে ' . $data->to_date . ' ছুটি হয়েছে ';

            $status = optional(SmsStatus::first())->teacher_leave;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            return redirect()->route('teacher.leave')->with('success', 'Leave created successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherLeaveShow($id)
    {
        try {
            $invoice = InvoiceDesign::first();
            $data = Leave::with('teacher:id,name,reg_no,phone','users:id,name')->findOrFail($id);
            return view('dashboard.teachers.leaves.leave_show', compact('data','invoice'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherLeaveDestroy($id)
    {
        try {
            $data = Leave::findOrFail($id);
            $data->delete();

             return response()->json([
                 'success' => true,
                 'message' => 'Data deleted successfully.',
             ]);
         } catch (\Exception $exception) {
             return response()->json([
                 'success' => false,
                 'message' => 'Data delete failed',
             ]);
         }
    }

    public function TeacherLeaveEdit($id)
    {
        try {
            $data = Leave::with('teacher:id,name,reg_no','users:id,name')->findOrFail($id);
            $teachers = Teacher::whereNull('discharge_status')->select('id','name','phone','reg_no')->get();
            return view('dashboard.teachers.leaves.leave_edit', compact('data','teachers'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function TeacherLeaveUpdate(Request $request, $id)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
            'from_date.required' => 'Enter from date',
            'to_date.required' => 'Enter to date',
        ];

        $request->validate([
            'teacher_id' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
        ], $messages);

        $from = Carbon::parse($request->from_date)->format('Y-m-d');
        $to = Carbon::parse($request->to_date)->format('Y-m-d');
        $exists = Leave::where('teacher_id', $request->teacher_id)
        ->where('id', '!=', $id)
        ->where(function($query) use ($from, $to) {
            $query->whereBetween('from_date', [$from, $to])
                  ->orWhereBetween('to_date', [$from, $to])
                  ->orWhere(function($query) use ($from, $to) {
                      $query->where('from_date', '<=', $from)
                            ->where('to_date', '>=', $to);
                  });
        })
        ->exists();

        if($exists){
            return redirect()->back()->with('error', 'Leave for the selected dates has already been applied for.');
        }

        try {
            $data = Leave::findOrFail($id);
            $data->teacher_id = $request->teacher_id;
            $data->from_date = Carbon::parse($request->from_date)->format('Y-m-d');
            $data->to_date = Carbon::parse($request->to_date)->format('Y-m-d');
            $data->days = $request->days;
            $data->type = 1;
            $data->note = $request->note;
            $data->updated_by = Auth::user()->id;
            $data->save();

            $teacher = Teacher::findOrFail($request->teacher_id);
            $site = DB::table('settings')->first();

            $to = $teacher->phone;
            $text = $teacher->name . ', ' . $data->from_date . ' থেকে ' . $data->to_date . ' ছুটি হয়েছে ';

            $status = optional(SmsStatus::first())->teacher_leave;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            return redirect()->route('teacher.leave')->with('success', 'Leave updated successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }


    public function StudentLeaveDestroy($id)
    {
        try {
            $data = Leave::findOrFail($id);
            $data->delete();

             return response()->json([
                 'success' => true,
                 'message' => 'Data deleted successfully.',
             ]);
         } catch (\Exception $exception) {
             return response()->json([
                 'success' => false,
                 'message' => 'Data delete failed',
             ]);
         }
    }
    public function TeacherResponsibility(Request $request)
    {
        try {

            if ($request->ajax()) {

                $data = ResponsibilityAssign::with('teacher:id,name,phone,reg_no','createdBy:id,name')->groupBy('teacher_id')->get();

                return Datatables::of($data)

                    ->addColumn('teacher', function ($data) {
                        $name = isset($data->teacher) ? $data->teacher->name : '--';
                        $reg = isset($data->teacher) ? $data->teacher->reg_no : '--';
                        return $name ;
                    })

                    ->addColumn('givedBy', function ($data) {
                        return $data->createdBy->name ?? ''; ;
                    })

                   ->addColumn('action', function ($data) {
    $details = '<a href="' . route('teacher.responsibility.show', $data->teacher_id) . '" class="btn btn-sm btn-info" title="Details"><i class="fa fa-eye"></i> Details</a> ';
    $edit    = '<a href="' . route('teacher.responsibility.edit', $data->teacher_id) . '" class="btn btn-sm btn-success" title="Edit"><i class="fa fa-edit"></i> Edit</a> ';
    $delete  = '<a href="#" data-remote="' . route('teacher.responsibility.destroy', $data->teacher_id) . '" class="btn btn-sm btn-danger btn-delete" title="Delete"><i class="fa fa-trash"></i> Delete</a>';

    return $details . $edit . $delete;
})


                    ->addIndexColumn()
                    ->rawColumns(['givedBy','teacher','action'])
                    ->toJson();
                }
                return view('dashboard.teachers.responsibility.index');
            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
    }

    public function TeacherResponsibilityCreate()
    {
        $teachers = Teacher::whereNull('discharge_status')->whereNotIn('id', function($query) {
            $query->select('teacher_id')
                  ->from('responsibility_assigns')
                  ->whereNull('deleted_at');
        })->select('id','name','phone','reg_no')->get();
        $responsibilities = TeacherResponsibility::all();
        return view('dashboard.teachers.responsibility.create', compact('teachers','responsibilities'));
    }
    public function TeacherResponsibilityStore(Request $request)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
        ];

        $request->validate([
            'teacher_id' => 'required',
        ], $messages);

        try {

            $existing = ResponsibilityAssign::where('teacher_id', $request->teacher_id)->exists();

            if ($existing) {
                return redirect()->back()->with('error', 'Responsibility data already exists');
            }

            foreach($request->responsibility_id as $key => $responsibilityId) {
                $data = new ResponsibilityAssign();
                $data->teacher_id = $request->teacher_id;
                $data->responsibility_id = $responsibilityId;
                $data->note = $request->note;
                $data->created_by = Auth::user()->id;
                $data->save();
            }

            return redirect()->route('teacher.responsibility')->with('success', 'Responsibility created successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherResponsibilityShow($id)
    {
        try {
            $data = ResponsibilityAssign::with('teacher:id,name,phone,reg_no','createdBy:id,name')->where('teacher_id', $id)->first();
            $responsibilities = ResponsibilityAssign::with('responsibilities:id,name')->where('teacher_id', $id)->get();
            return view('dashboard.teachers.responsibility.show', compact('data','responsibilities'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherResponsibilityEdit($id)
    {
        try {
            $data = ResponsibilityAssign::with('teacher:id,name,phone')->where('teacher_id',$id)->first();
            $teachers = Teacher::whereNull('discharge_status')->where(function ($query) use ($data) {
                $query->whereNotIn('id', function ($subquery) {
                    $subquery->select('teacher_id')
                            ->from('responsibility_assigns')
                             ->whereNull('deleted_at');
                })->orWhere('id', $data->teacher_id);
            })->select('id','name','phone','reg_no')->get();
            $responsibilities = TeacherResponsibility::all();
            $assignRes = ResponsibilityAssign::where('teacher_id', $data->teacher_id)->get();
            return view('dashboard.teachers.responsibility.edit', compact('data','teachers','responsibilities','assignRes'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function TeacherResponsibilityUpdate(Request $request, $id)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
        ];

        $request->validate([
            'teacher_id' => 'required',
        ], $messages);

        try {

            ResponsibilityAssign::where('teacher_id', $request->teacher_id)->delete();

            $existing = ResponsibilityAssign::where('teacher_id', $request->teacher_id)->exists();

            if ($existing) {
                return redirect()->back()->with('error', 'Responsibility data already exists');
            }

            foreach($request->responsibility_id as $key => $responsibilityId) {
                $data = new ResponsibilityAssign();
                $data->teacher_id = $request->teacher_id;
                $data->responsibility_id = $responsibilityId;
                $data->note = $request->note;
                $data->created_by = Auth::user()->id;
                $data->save();
            }

            return redirect()->route('teacher.responsibility')->with('success', 'Responsibility updated successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherResponsibilityDestroy($id)
    {
        try {

          ResponsibilityAssign::where('teacher_id', $id)->delete();

             return response()->json([
                 'success' => true,
                 'message' => 'Data deleted successfully.',
             ]);
         } catch (\Exception $exception) {
             return response()->json([
                 'success' => false,
                 'message' => 'Data delete failed',
             ]);
         }
    }
    public function TeacherBookDistribute(Request $request)
    {
        try {

            if ($request->ajax()) {

                $data = TeacherBookDistribute::with('teacher:id,name,phone,reg_no','createdBy:id,name')->groupBy('teacher_id')->get();

                return Datatables::of($data)

                    ->addColumn('teacher', function ($data) {
                        $name = isset($data->teacher) ? $data->teacher->name : '--';
                        $reg = isset($data->teacher) ? $data->teacher->reg_no : '--';
                        return $name ;
                    })

                    ->addColumn('givedBy', function ($data) {
                        return $data->createdBy->name ?? ''; ;
                    })

                  ->addColumn('action', function ($data) {
    $details = '<a href="' . route('teacher.book.distribute.show', $data->teacher_id) . '" class="btn btn-sm btn-info" title="Details"><i class="fa fa-eye"></i> Details</a> ';
    $edit    = '<a href="' . route('teacher.book.distribute.edit', $data->teacher_id) . '" class="btn btn-sm btn-success" title="Edit"><i class="fa fa-edit"></i> Edit</a> ';
    $delete  = '<a href="#" data-remote="' . route('teacher.book.distribute.destroy', $data->teacher_id) . '" class="btn btn-sm btn-danger btn-delete" title="Delete"><i class="fa fa-trash"></i> Delete</a>';

    return $details . $edit . $delete;
})


                    ->addIndexColumn()
                    ->rawColumns(['givedBy','teacher','action'])
                    ->toJson();
                }
                return view('dashboard.teachers.books.index');
            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
    }

    public function TeacherBookDistributeCreate()
    {
        $teachers = Teacher::whereNull('discharge_status')->whereNotIn('id', function($query) {
            $query->select('teacher_id')
                  ->from('teacher_book_distributes')
                  ->whereNull('deleted_at');
        })->select('id','name','phone','reg_no')->get();


        $subjects = Subject::all();
        $sessions = StudentSession::all();
        $exams = StudentExam::all();
        return view('dashboard.teachers.books.create', compact('teachers','subjects','sessions','exams'));
    }
    public function TeacherBookDistributeStore(Request $request)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
        ];

        $request->validate([
            'teacher_id' => 'required',
        ], $messages);

        $existing = TeacherBookDistribute::where('teacher_id', $request->teacher_id)->where('session_id', $request->session_id)->where('exam_id', $request->exam_id)->exists();

        if( $existing){
            return redirect()->back()->with('error', 'Kitab already assigned to the teacher');
        }

        try {
            foreach($request->subject_id as $key => $subjectId) {
                $data = new TeacherBookDistribute();
                $data->teacher_id = $request->teacher_id;
                $data->session_id = $request->session_id;
                $data->exam_id = $request->exam_id;
                $data->subject_id = $subjectId;
                $data->note = $request->note;
                $data->created_by = Auth::user()->id;
                $data->save();
            }

            return redirect()->route('teacher.book.distribute')->with('success', 'Kitab distribute created successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherBookDistributeShow($id)
    {
        try {
            $data = TeacherBookDistribute::with('teacher:id,name,phone,reg_no','createdBy:id,name','exam:id,name','stusession:id,name')->where('teacher_id', $id)->first();
            $subjects = TeacherBookDistribute::with('subject')->where('teacher_id', $id)->get();
            return view('dashboard.teachers.books.show', compact('data','subjects'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherBookDistributeEdit($id)
    {
        try {
            $data = TeacherBookDistribute::with('teacher:id,name,phone,reg_no')->where('teacher_id', $id)->first();

            $teachers = Teacher::whereNull('discharge_status')->where(function ($query) use ($data) {
                $query->whereNotIn('id', function ($subquery) {
                    $subquery->select('teacher_id')
                             ->from('teacher_book_distributes')
                             ->whereNull('deleted_at');
                })->orWhere('id', $data->teacher_id);
            })->select('id','name','phone','reg_no')->get();


            $subjects = Subject::all();
            $sessions = StudentSession::all();
            $exams = StudentExam::all();
            $assignSub = TeacherBookDistribute::where('teacher_id', $data->teacher_id)->get();
            return view('dashboard.teachers.books.edit', compact('data','teachers','subjects','assignSub','sessions','exams'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function TeacherBookDistributeUpdate(Request $request, $id)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
        ];

        $request->validate([
            'teacher_id' => 'required',
        ], $messages);

        try {

            TeacherBookDistribute::where('teacher_id', $request->teacher_id)->delete();

            $existing = TeacherBookDistribute::where('teacher_id', $request->teacher_id)
            ->where('session_id', $request->session_id)->where('exam_id', $request->exam_id)->exists();

            if( $existing){
                return redirect()->back()->with('error', 'Kitab already assigned to the teacher');
            }

            foreach($request->subject_id as $key => $subjectId) {
                $data = new TeacherBookDistribute();
                $data->teacher_id = $request->teacher_id;
                $data->session_id = $request->session_id;
                $data->exam_id = $request->exam_id;
                $data->subject_id = $subjectId;
                $data->note = $request->note;
                $data->created_by = Auth::user()->id;
                $data->save();
            }

            return redirect()->route('teacher.book.distribute')->with('success', 'Kitab distribute updated successfully');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherBookDistributeDestroy($id)
    {
        try {
            TeacherBookDistribute::where('teacher_id', $id)->delete();
             return response()->json([
                 'success' => true,
                 'message' => 'Data deleted successfully.',
             ]);
         } catch (\Exception $exception) {
             return response()->json([
                 'success' => false,
                 'message' => 'Data delete failed',
             ]);
         }
    }

    public function TeacherSalary(Request $request)
    {
        try {

            if ($request->ajax()) {

                $data = FundDetail::with('teacher:id,name,salary')->where('type', 13)
                ->selectRaw('month, teacher_id, SUM(amount) as total_amount')
                ->groupBy('month', 'teacher_id')->get();

                return Datatables::of($data)

                ->addColumn('date', function ($data) {
                
                    return \Carbon\Carbon::createFromFormat('Y-m', trim($data->month))->format('M-Y');
                })



                    ->addColumn('teacher', function ($data) {
                        $name = isset($data->teacher) ? $data->teacher->name : '--';
                        $reg = isset($data->teacher) ? $data->teacher->reg_no : '--';
                        return $name . '<br>'. $reg ;
                    })

                    ->addColumn('salary', function ($data) {
                        $salary = isset($data->teacher) ? $data->teacher->salary : '--';
                        return $salary;
                    })

                    ->addColumn('paid', function ($data) {
                        return $data->total_amount ?? '--';
                    })

                    ->addColumn('due', function ($data) {
                        $salary = isset($data->teacher) ? $data->teacher->salary : '--';
                        $due = $salary - $data->total_amount;
                        return $due;
                    })

                    ->addColumn('action', function ($data) {
                        $details = '<a type="button" id="print" class="btn btn-sm btn-primary print mr-1" href="' . route('teacher.salary.details', ['month' => $data->month, 'teacher_id' => $data->teacher_id]) . '" title="Print"><i class="fa fa-eye"></i></a>';
                        return $details;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['date','paid','teacher','salary','action'])
                    ->toJson();
                }
                return view('dashboard.teachers.salary_pay.index');
            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
    }

    public function TeacherSalaryDetails(Request $request , $month, $teacher_id)
    {
        try {
            if ($request->ajax()) {

                $data = FundDetail::where('month', $month)
                        ->where('teacher_id', $teacher_id)
                        ->where('type', 13)
                        ->get();

                if ($data->isEmpty()) {
                    return response()->json([
                        'error' => 'No payments found for this student and month.',
                    ]);
                }

                $lastRecord = FundDetail::where('month', $month)
                    ->where('teacher_id', $teacher_id)
                    ->where('type', 13)
                    ->orderBy('id', 'desc')
                    ->first();

                return Datatables::of($data)

                    ->addColumn('date', function ($data) {
                        return Carbon::parse($data->date)->format('d/m/Y');
                    })

                    ->addColumn('amount', function ($data) {
                        return $data->amount ?? '';
                    })

                    ->addColumn('action', function ($data) use ($lastRecord) {

                        $edit = '';

                        if ($data->id == $lastRecord->id) {
                            $edit = '<a id="edit" href="' . route('teacher.salary.edit', $data->id) . '" class="btn btn-sm btn-info edit" title="Edit"><i class="fa fa-edit"></i></a> ';
                        }

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('teacher.salary.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        $print = '<a type="button" id="print" class="btn btn-sm btn-primary print mr-1" href="' . route('teacher.salary.print', $data->id) . ' " title="a6 page"><i class="fa fa-file"></i></a>';

                        return  $edit . $print . $delete;
                    })


                    ->addIndexColumn()
                    ->rawColumns(['action', 'date', 'amount','discount'])
                    ->toJson();
            }

            $teacher = Teacher::find($teacher_id);
            if (!$teacher) {
                return redirect()->back()->with('error', 'Teacher not found.');
            }

            return view('dashboard.teachers.salary_pay.details', compact('teacher_id', 'month', 'teacher','teacher_id'));

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherSalaryFind(Request $request)
    {
        $salary = Teacher::findOrFail($request->teacher_id);
        // $monthString = $request->month;
        // $carbonDate = Carbon::createFromFormat('F-Y', $monthString);
        $month = $request->month;

        $total = FundDetail::where('teacher_id', $request->teacher_id)
            ->where('month', $month)
            ->where('type', 13)
            ->where('payment_type', 2)
            ->select(
                DB::raw('SUM(amount) as total_paid'),
            )
            ->first();

        return response()->json([
            'salary' => $salary->salary,
            'total_paid' => $total->total_paid ?? 0,
        ]);
    }

    public function TeacherSalaryCreate()
    {
        $teachers = Teacher::whereNull('discharge_status')->select('id','name','phone','reg_no')->get();
        $funds = Fund::all();
        return view('dashboard.teachers.salary_pay.create', compact('teachers','funds'));
    }
    public function TeacherSalaryStore(Request $request)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
        ];

        $request->validate([
            'teacher_id' => 'required',
        ], $messages);

        try {

            $lastFundDetail = FundDetail::whereNotNull('receipt_no')
            ->orderByDesc('receipt_no')
            ->first();
            $receipt_no = $lastFundDetail ? $lastFundDetail->receipt_no + 1 : 1;

            $totalReceived = FundDetail::where('teacher_id', $request->teacher_id)
            ->where('type', 13)
            ->where('month', Carbon::parse($request->month)->format('Y-m'))
            ->sum('amount');

            $totalAmount = (float)$request->total_amount;
            $totalReceived = (float)$totalReceived + (float)$request->amount;

            if ($totalReceived > $totalAmount) {
                return 'Salary already paid for ' . Carbon::parse($request->month)->format('F Y');
            }

            $data = new FundDetail();
            $data->fund_id        = $request->fund_id;
            $data->teacher_id     = $request->teacher_id;
            $data->receipt_no     = $receipt_no;
            $data->purpose        = 'Teacher salary pay';
            $data->date           = now()->format('Y-m-d');
            $data->type           = 13;
            $data->payment_type   = 2;
            $data->fund_type      = 1;
            $data->month          = Carbon::parse($request->month)->format('Y-m');
            $data->amount         = $request->amount;
            $data->save();

            $teacher = Teacher::findOrFail($request->teacher_id);
            $site = DB::table('settings')->first();

            $to = $teacher->phone;
            $text = $teacher->name . ', ' .  $data->month . ', Salary Paid : '. $data->amount . ' TK' ;

            $status = optional(SmsStatus::first())->teacher_salary;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            return redirect()->route('teacher.salary.print', ['id' => $data->id])
                         ->with('success', 'Salary paid successfully and ready for print.');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherSalaryEdit($id)
    {
        $data = FundDetail::with('teacher')->findOrFail($id);
        $teachers = Teacher::whereNull('discharge_status')->get();
        $funds = Fund::all();
        return view('dashboard.teachers.salary_pay.edit', compact('data','teachers','funds'));
    }


    public function TeacherSalaryUpdate(Request $request, $id)
    {
        $messages = [
            'teacher_id.required' => 'Select teacher',
            'amount.required' => 'Enter amount',
        ];

        $request->validate([
            'teacher_id' => 'required',
            'amount' => 'required',
        ], $messages);

        try {

            $totalReceived = FundDetail::where('teacher_id', $request->teacher_id)
                ->where('type', 13)
                ->where('month', Carbon::parse($request->month)->format('Y-m'))
                ->sum('amount');

            $totalAmount = (float)$request->total_amount;
            $totalReceived = (float)$totalReceived + (float)$request->amount;

            if ($totalReceived > $totalAmount) {
                return 'Salary already paid for ' . Carbon::parse($request->month)->format('F Y');
            }

            $data = FundDetail::findOrFail($id);
            $data->fund_id        = $request->fund_id;
            $data->teacher_id     = $request->teacher_id;
            $data->purpose        = 'Teacher salary pay';
            $data->date           = $data->date;
            $data->type           = 13;
            $data->payment_type   = 2;
            $data->fund_type      = 1;
            $data->month          = Carbon::parse($request->month)->format('Y-m');
            $data->amount         = $request->amount;
            $data->save();

            $teacher = Teacher::findOrFail($request->teacher_id);
            $site = DB::table('settings')->first();

            $to = $teacher->phone;
            $text = $teacher->name . ', ' .  $data->month . ', Salary Paid : '. $data->amount . ' TK' ;

            $status = optional(SmsStatus::first())->teacher_salary;
            if($status == 1){
                $this->SendSms($to, $text);
            }

            return redirect()->route('teacher.salary.print', ['id' => $data->id])
                         ->with('success', 'Salary updated successfully and ready for print.');

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'Error: ' . $exception->getMessage());
        }
    }

    public function TeacherSalaryDestroy($id)
    {
        try {
            $data = FundDetail::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }
    public function TeacherSalaryPrint($id)
    {
        try {
            $data = FundDetail::with('teacher:id,name,phone,reg_no,salary')->findOrFail($id);
            $totalPaid = FundDetail::where('teacher_id', $data->teacher_id)->where('type', 13)->where('month', $data->month)->sum('amount');
            $design = InvoiceDesign::first();
           return view('dashboard.teachers.salary_pay.salary_print', compact('data','design','totalPaid'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('success', $exception);
        }
    }
    public function TeacherDischarge(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = Teacher::select('id','name','phone','reg_no','discharge_status','discharge_note')->whereNotNull('discharge_status')->get();

                return Datatables::of($data)

                    ->addColumn('discharge_note', function ($data) {
                        return $data->discharge_note;
                    })

                    ->addColumn('teacherName', function ($data) {
                        $name = isset($data->name) ? $data->name : '--';
                        $phone = isset($data->phone) ? $data->phone : '--';
                        $reg_no = isset($data->reg_no) ? $data->reg_no : '--';

                        return  $name . '<br />' . $phone . '<br />' . $reg_no;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('teacher.discharge.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $print = '<a type="button" id="print" class="btn btn-sm btn-info print mr-1" href="' . route('teacher.discharge.print', $data->id) . ' " title="Print"><i class="fa fa-file"></i></a>';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('teacher.discharge.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $print . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['discharge_note', 'action','teacherName'])
                    ->toJson();
            }

            $teachers = Teacher::select('id','name','phone')->whereNull('discharge_status')->get();
            $teacherEdit = Teacher::select('id','name','phone')->get();
            return view('dashboard.teachers.discharge', compact('teachers' , 'teacherEdit'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherDischargePrint($id)
    {
        try {
            $data = Teacher::findOrFail($id);
            $design = InvoiceDesign::first();
           return view('dashboard.teachers.discharge_print', compact('data','design'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('success', $exception);
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function TeacherDischargeStore(Request $request)
    {

        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'discharge_note' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {

              $exists = Teacher::whereNotNull('discharge_status')->where('id', $request->teacher_id)->exists();

              if($exists){
                return response()->json([
                    'success' => false,
                    'message' => 'This teacher already discharged',
                ]);
              }

                $teacher = Teacher::findOrFail($request->teacher_id);
                $teacher->discharge_status = 1;
                $teacher->discharge_note = $request->discharge_note;
                $teacher->created_by = Auth::user()->id;
                $teacher->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Teacher discharge successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function TeacherDischargeEdit($id)
    {
        $data = Teacher::findOrFail($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function TeacherDischargeUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'discharge_note' => 'required',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $exists = Teacher::whereNotNull('discharge_status')
                            ->where('id', '!=', $id)
                            ->where('id', $request->teacher_id)
                            ->exists();

            if ($exists) {
                return response()->json([
                    'success' => false,
                    'message' => 'Another teacher has already been discharged.',
                ]);
            }

            if($request->teacher_id  == $id){
                $teacher = Teacher::findOrFail($id);
                $teacher->discharge_status = 1;
                $teacher->discharge_note = $request->discharge_note;
                $teacher->created_by = Auth::user()->id;
                $teacher->save();
            }else{
                $preTeacher = Teacher::findOrFail($id);
                $preTeacher->discharge_status = null;
                $preTeacher->discharge_note = null;
                $preTeacher->updated_by = Auth::user()->id;
                $preTeacher->save();

                $teacher = Teacher::where('id', $request->teacher_id)->first();
                $teacher->discharge_status = 1;
                $teacher->discharge_note = $request->discharge_note;
                $teacher->updated_by = Auth::user()->id;
                $teacher->save();
            }

            return response()->json([
                'success' => true,
                'message' => 'Data updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function TeacherDischargeDestroy($id)
    {
        try {
            $teacher = Teacher::findOrFail($id);
            // $teacher->discharge_status = null;
            $teacher->save();
            $teacher->delete();

            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }

    public function TeacherIdcard($id)
    {
        $data = Teacher::findOrFail($id);
        $setting = Setting::first();
        $design = InvoiceDesign::first();
        return view('dashboard.teachers.id_card', compact('data','setting','design'));
    }
    public function TeacherBonus(Request $request, $id)
    {
        try {
            if ($request->ajax()) {

                    $data = FundDetail::where('type', 17)->where('teacher_id', $id)->select('id','fund_id','purpose','amount' , 'date')->get();

                    return Datatables::of($data)

                        ->addColumn('date', function ($data) {
                            $date = Carbon::parse($data->date)->format('d/m/Y');
                            return $date;
                        })

                        ->addColumn('amount', function ($data) {
                            return round($data->amount);
                        })

                        ->addColumn('purpose', function ($data) {
                            return $data->purpose;
                        })

                        ->addColumn('action', function ($data) {

                            $print = '<a type="button" id="print" class="btn btn-sm btn-info print mr-1" href="' . route('teacher.bonus.print', $data->id) . ' " title="Print"><i class="fa fa-file"></i></a>';

                            $edit = '<a id="edit" href="' . route('teacher.bonus.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                            $delete = '';
                            if ($this->DeleteData()) {
                                $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('teacher.bonus.delete', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                            }

                            return $edit . $print . $delete;
                        })

                        ->addIndexColumn()
                        ->rawColumns(['date', 'amount', 'purpose', 'action'])
                        ->toJson();
                }
            $teacher = Teacher::find($id);
            $funds = Fund::all();
            return view('dashboard.teachers.bonus', compact('teacher','funds'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function TeacherBonusStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'amount' => 'required',
                'purpose' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {

                $type = Fund::findOrFail($request->fund_id);
                $lastFundDetail = FundDetail::whereNotNull('receipt_no')
                ->orderByDesc('receipt_no')
                ->first();
                $receipt_no = $lastFundDetail ? $lastFundDetail->receipt_no + 1 : 1;

                $data = new FundDetail();
                $data->receipt_no = $receipt_no;
                $data->date = now();
                $data->teacher_id = $request->teacher_id;
                $data->fund_id = $request->fund_id;
                $data->amount = $request->amount;
                $data->purpose = $request->purpose ? : 'Teacher bonus pay';
                $data->type = 17;
                $data->fund_type = $type->fund_type;
                $data->payment_type = 2;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Bonus created successfully',
                ]);

            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function TeacherBonusEdit($id)
    {
        $data = FundDetail::findOrFail($id);
        return response()->json($data);
    }

    public function TeacherBonusUpdate(Request $request, $id)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'amount' => 'required',
                'purpose' => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {

                $type = Fund::findOrFail($request->fund_id);
                $data = FundDetail::findOrFail($id);
                $data->date = now();
                $data->teacher_id = $request->teacher_id;
                $data->fund_id = $request->fund_id;
                $data->amount = $request->amount;
                $data->purpose = $request->purpose ? : 'Teacher bonus pay';
                $data->type = 17;
                $data->fund_type = $type->fund_type;
                $data->payment_type = 2;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Bonus updated successfully',
                ]);

            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function TeacherBonusPrint($id)
    {
        try {
            $data = FundDetail::with('teacher:id,name,phone,reg_no,salary')->findOrFail($id);
            $design = InvoiceDesign::first();
           return view('dashboard.teachers.bonus_print', compact('data','design'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('success', $exception);
        }
    }
    public function TeacherBonusDelete($id)
    {
        try {
            $data = FundDetail::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Bonus deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Bonus delete failed',
            ]);
        }
    }

    public function TeacherDueAdvance()
    {
        $teachers = Teacher::whereNull('discharge_status')->get();
        $funds = Fund::all();
        return view('dashboard.teachers.due_collect.create',compact('teachers','funds'));
    }

    public function TeacherMonthlySalary(Request $request)
    {
        $months = $request->months;
        $teacher_id = $request->teacher_id;

        $monthlyData = [];
        $totalPaid = 0;
        $totalDue = 0;

        $teacher = Teacher::findOrFail($teacher_id);
        $monthlySalary = $teacher->salary;

        foreach ($months as $monthString) {
            $carbonDate = Carbon::createFromFormat('F-Y', $monthString);
            $month = $carbonDate->format('Y-m');

            $paidAmount = FundDetail::where('type', 13)
                ->where('teacher_id', $teacher_id)
                ->where('month', $month)
                ->sum('amount');

            $due = $monthlySalary - $paidAmount;

            $totalPaid += $paidAmount;
            $totalDue += $due;

            $monthlyData[] = [
                'month' => $monthString,
                'totalPaid' => $paidAmount,
                'salary' => $monthlySalary,
                'due' => $due
            ];
        }

        return response()->json([
            'monthlyData' => $monthlyData,
            'totalPaid' => $totalPaid,
            'salary' => $monthlySalary,
            'totalDue' => $totalDue,
        ]);
    }

    public function TeacherMonthlySalaryStore(Request $request)
    {
        DB::beginTransaction();

        try {
            $lastFundDetail = FundDetail::whereNotNull('receipt_no')
            ->orderByDesc('receipt_no')
            ->first();

            $receipt_no = $lastFundDetail ? $lastFundDetail->receipt_no + 1 : 1;

            $months = $request->months;
            $totalAmount = (float)$request->total_amount;
            $amountReceived = (float)$request->amount;

            $monthsCount = count($months);
            $monthlyAmount = round($totalAmount / $monthsCount);
            $alreadyPaidMonths = [];

            foreach ($months as $month) {
                $monthFormatted = Carbon::parse($month)->format('Y-m');
                $totalPaidForMonth = FundDetail::where('teacher_id', $request->teacher_id)
                    ->where('type', 13)
                    ->where('month', $monthFormatted)
                    ->sum('amount');

                if ($totalPaidForMonth >= $monthlyAmount) {
                    $alreadyPaidMonths[] = Carbon::parse($month)->format('F Y');
                }
            }

            if (!empty($alreadyPaidMonths)) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Salary already paid for month(s): ' . implode(', ', $alreadyPaidMonths),
                ], 422);
            }

            $processedMonths = [];
            $remainingAmount = $amountReceived;

            foreach ($months as $index => $month) {

                if ($remainingAmount <= 0) {
                    break;
                }

                $monthFormatted = Carbon::parse($month)->format('Y-m');
                $monthlyPaid = FundDetail::where('teacher_id', $request->teacher_id)
                    ->where('type', 13)
                    ->where('month', $monthFormatted)
                    ->sum('amount');

                $monthlyDue = max(0, $monthlyAmount - $monthlyPaid);
                if ($monthlyDue <= 0) {
                    continue;
                }

                $amountForThisMonth = min($monthlyDue, $remainingAmount);

                $data = new FundDetail();
                $data->fund_id        = $request->fund_id;
                $data->teacher_id     = $request->teacher_id;
                $data->receipt_no     = $receipt_no;
                $data->purpose        = 'Teacher salary pay';
                $data->date           = now()->format('Y-m-d');
                $data->type           = 13;
                $data->payment_type   = 2;
                $data->fund_type      = 1;
                $data->month          = $monthFormatted;
                $data->amount         = $amountForThisMonth;
                $data->save();

                $remainingAmount -= $amountForThisMonth;
                $processedMonths[] = $monthFormatted;
            }

            if (!empty($processedMonths)) {
                $teacher = Teacher::findOrFail($request->teacher_id);
                $site = DB::table('settings')->first();

                $to = $teacher->phone;
                $text = $site->name . ', ' . $teacher->name . ', Your ' . implode(', ', $processedMonths) . ', Salary Paid: ' . ($amountReceived - $remainingAmount) . ' TK';

                $status = optional(SmsStatus::first())->teacher_salary;
                if ($status == 1) {
                    $this->SendSms($to, $text);
                }

                DB::commit();

                return redirect()->route('teacher.monthly.salary.print', ['id' => $data->teacher_id, 'receipt' => $data->receipt_no ])
                ->with('success', 'Salary paid successfully and ready for print.');

            } else {
                DB::rollBack();
                return back()->with('error', 'No payment was processed - all selected months are already paid or no amount left to allocate');
            }

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error processing payment: ' . $e->getMessage());
        }
    }

    public function TeacherMonthlySalaryPrint($id, $receipt)
    {
        $fundDetails = FundDetail::with('teacher')
            ->where('teacher_id', $id)
            ->where('type', 13)
            ->where('payment_type', 2)
            ->where('receipt_no', $receipt)
            ->get();

        if ($fundDetails->isEmpty()) {
            abort(404, 'No payment data found.');
        }

        $months = $fundDetails->pluck('month')->unique()->sort();

        $totalPaid = FundDetail::where('type', 13)
            ->where('teacher_id', $id)
            ->where('payment_type', 2)
            ->whereIn('month', $months)
            ->sum('amount');

        $invoice = $fundDetails->first();

        $currentEntries = $fundDetails->filter(function ($item) use ($invoice) {
            return $item->date == $invoice->date && $item->receipt_no == $invoice->receipt_no;
        });

        $currentPaid = $currentEntries->sum('amount');

        $previousPaid = $totalPaid - $currentPaid;

        $teacherData = Teacher::findOrFail($id);
        $monthlySalary = $teacherData->salary ?? 0;

        $totalSalary = $monthlySalary * $months->count();
        $totalDue = $totalSalary - $totalPaid;

        $design = InvoiceDesign::first();

        $data = $invoice;

        return view('dashboard.teachers.due_collect.print', compact(
            'design',
            'data',
            'fundDetails',
            'months',
            'teacherData',
            'invoice',
            'currentPaid',
            'totalPaid',
            'previousPaid',
            'totalDue',
            'monthlySalary',
            'totalSalary',
        ));
    }

}
