<?php

namespace App\Http\Middleware;

use Closure;

class CheckPermission {
    public function handle($request, Closure $next, string $permKey) {
        $user = auth()->user();

        if (!$user) {
            abort(403, 'Unauthorized');
        }

        // ✅ যদি permission থাকে
        if ($user->canPerm($permKey)) {
            return $next($request);
        }

        // ✅ অথবা যদি type==1 বা role_id==1 হয়
        if ($user->type == 1 || $user->role_id == 1) {
            return $next($request);
        }

        // ❌ অন্যথায় deny
        // abort(403, 'Access denied');
        return response()->view('dashboard.error.403', [], 403);
    }
}
