<?php

namespace App\Models;

use App\Models\Student;
use App\Models\StudentClass;
use App\Models\StudentSession;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ExamSeat extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded = [];

    public function students(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function stuclass(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }
    public function stusession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }
    public function exam(): BelongsTo
    {
        return $this->belongsTo(StudentExam::class, 'exam_id', 'id')->withTrashed();
    }
    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withTrashed();
    }
    public function admitCard()
    {
        return $this->hasOne(AdmitCard::class, 'student_id', 'student_id');
    }

    
}
