<?php

namespace App\Models;

use App\Models\StudentClass;
use App\Models\StudentSession;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FeeAssign extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded = [];

    public function studentsession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }

    public function class(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }



    public function feesDetails()
    {
        return $this->hasOne(FeeAssignDetail::class, 'fee_assign_id', 'id');
    }
}
