<?php

namespace App\Models;

use App\Models\FeeAssign;
use App\Models\StudentFee;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FeeAssignDetail extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded = [];

    public function fees(): BelongsTo
    {
        return $this->belongsTo(StudentFee::class, 'fee_id', 'id')->withTrashed();
    }

    public function feeAssign(): BelongsTo
    {
        return $this->belongsTo(FeeAssign::class, 'fee_assign_id', 'id')->withTrashed();
    }

    public function studentsession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }

    public function class(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }
}
