<?php

namespace App\Models;

use App\Models\Fund;
use App\Models\Shop;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class HostelDue extends Model
{
    use HasFactory, SoftDeletes;
    public function shop(): BelongsTo
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withTrashed();
    }
    public function fund(): BelongsTo
    {
        return $this->belongsTo(Fund::class, 'fund_id', 'id')->withTrashed();
    }
}
