<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Loan extends Model
{
    use HasFactory, SoftDeletes;
    public function returnby(): BelongsTo
    {
        return $this->belongsTo(Loan::class, 'return_by', 'id')->withTrashed();
    }

    public function takenby(): BelongsTo
    {
        return $this->belongsTo(Loan::class, 'taken_by', 'id')->withTrashed();
    }
}
