<?php

namespace App\Models;

use App\Models\Fund;
use App\Models\User;
use App\Models\FundDetail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Mahfil extends Model
{
    use HasFactory, SoftDeletes;

    public function funds(): BelongsTo
    {
        return $this->belongsTo(Fund::class, 'fund_id', 'id')->withTrashed();
    }
    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withTrashed();
    }
    public function fundDetails()
    {
        return $this->hasOne(FundDetail::class, 'mahfil_id', 'id')->withTrashed();
    }
}
