<?php

namespace App\Models;

use App\Models\Student;
use App\Models\FundDetail;
use App\Models\StudentClass;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MoneyReceipt extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function stuclass(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }

    public function students(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function payment(): HasOne
    {
        return $this->hasOne(FundDetail::class, 'student_payment_id', 'id');
    }
}
