<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RoshidDistribute extends Model
{
    use HasFactory, SoftDeletes;

    public function roshid(): BelongsTo
    {
        return $this->belongsTo(RoshidStock::class, 'roshid_stock_id', 'id')->withTrashed();
    }
    public function refundby(): BelongsTo
    {
        return $this->belongsTo(RoshidDistribute::class, 'roshid_refund_by', 'id')->withTrashed();
    }

    public function takenby(): BelongsTo
    {
        return $this->belongsTo(RoshidDistribute::class, 'roshid_taken_by', 'id')->withTrashed();
    }

}
