<?php

namespace App\Models;

use App\Models\RoshidDistribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RoshidStock extends Model
{
    use HasFactory, SoftDeletes;

    public function takenby(): BelongsTo
    {
        return $this->belongsTo(RoshidDistribute::class, 'roshid_taken_by', 'id')->withTrashed();
    }
}
