<?php

namespace App\Models;

use App\Models\Staff;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StaffHistory extends Model
{
    use HasFactory, SoftDeletes;

    public function staffs(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id')->withTrashed();
    }
}
