<?php

namespace App\Models;

use App\Models\User;
use App\Models\StudentComment;
use App\Models\ExamSeat;
use App\Models\StudentSession;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Student extends Model
{
    use HasFactory, SoftDeletes;

    public function users(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withTrashed();
    }

    public function stuclass(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }
    public function stusession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }

    // Inside Student model (app/Models/Student.php)
    public function getIncrementNumber($gender)
    {
        $latestStudent = self::where('gender', $gender)
                            ->whereDate('created_at', now()->toDateString())
                            ->orderByDesc('created_at')
                            ->first();

        $lastIncrement = $latestStudent ? substr($latestStudent->register_no, -2) : '00';
        return (int)$lastIncrement + 1;
    }

    public function examSeat()
    {
        return $this->hasOne(ExamSeat::class, 'student_id')->latest();
    }
    public function examComment()
    {
        return $this->hasOne(StudentComment::class, 'student_id')->latest();
    }
    public function results()
    {
        return $this->hasMany(Result::class, 'student_id', 'id');
    }


}
