<?php

namespace App\Models;

use App\Models\User;
use App\Models\Subject;
use App\Models\StudentExam;
use App\Models\StudentSession;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TeacherBookDistribute extends Model
{
    use HasFactory, SoftDeletes;

    public function teacher(): BelongsTo
    {
        return $this->belongsTo(Teacher::class, 'teacher_id', 'id')->withTrashed();
    }
    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class, 'subject_id', 'id')->withTrashed();
    }
    public function stusession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }
    public function exam(): BelongsTo
    {
        return $this->belongsTo(StudentExam::class, 'exam_id', 'id')->withTrashed();
    }
    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withTrashed();
    }
}
