<?php

namespace App\Models;

use App\Models\Expense;
use App\Models\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Transaction extends Model
{
    use HasFactory, SoftDeletes;

    public function teachers(): BelongsTo
    {
        return $this->belongsTo(Teacher::class, 'teacher_id', 'id')->withTrashed();
    }

    public function students(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function gurabaFunds(): BelongsTo
    {
        return $this->belongsTo(GurabaFund::class, 'guraba_fund_id', 'id')->withTrashed();
    }
    public function expenses(): BelongsTo
    {
        return $this->belongsTo(Expense::class, 'expense_id', 'id')->withTrashed();
    }
    public function staffs(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id')->withTrashed();
    }
}
