<?php

namespace App\Traits;

use Carbon\Carbon;

trait DateFormatter
{
    public function formatAnyDateToYmd($dateString)
    {
        $normalizedDate = preg_replace('/[\/\.,-]/', ' ', $dateString);

        try {
            $parsedDate = Carbon::parse($normalizedDate);
            return $parsedDate->format('Y-m-d');
        } catch (\Exception $e) {
            return $this->customParseDate($normalizedDate);
        }
    }

    public function customParseDate($dateString)
    {
        $patterns = [
            '/^(?P<day>\d{1,2})\s+(?P<month>\d{1,2})\s+(?P<year>\d{4})$/',
            '/^(?P<month>[A-Za-z]+)\s*,\s*(?P<year>\d{4})\s*-\s*(?P<day>\d{1,2})$/',
            '/^(?P<month>[A-Za-z]+)\s*-\s*(?P<year>\d{4})\s*-\s*(?P<day>\d{1,2})$/',
            '/^(?P<day>\d{1,2})\s+(?P<month>[A-Za-z]+)\s+(?P<year>\d{4})$/',
            '/^(?P<year>\d{4})\s+(?P<month>[A-Za-z]+)\s+(?P<day>\d{1,2})$/',
            '/^(?P<year>\d{4})\s+(?P<month>\d{1,2})\s+(?P<day>\d{1,2})$/',
        ];

        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $dateString, $matches)) {
                $day = $matches['day'];
                $month = $matches['month'];
                $year = $matches['year'];
                if (!is_numeric($month)) {
                    $monthNumber = date_parse($month)['month'];
                } else {
                    $monthNumber = $month;
                }
                return Carbon::create($year, $monthNumber, $day)->format('Y-m-d');
            }
        }

        throw new \Exception("Unable to parse the date: $dateString");
    }
}
