<?php

namespace App\Traits;

use App\Models\DataDelete;
use Carbon\Carbon;

trait DeleteTrait
{
    public function DeleteData(): bool
    {
        $del = DataDelete::first();

        if (!$del || !is_numeric($del->day)) {
            // Return false if no record is found or day is not a valid number
            return false;
        }

        $startDate = Carbon::parse($del->date);

        // Safely cast day value to integer before using in addDays()
        $endDate = $startDate->copy()->addDays((int) $del->day);

        // Return true if the current date/time is less than or equal to the end date
        return now()->lte($endDate);
    }
}
