<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Madrasha Management | Login</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.1/css/all.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #e0e0e0, #ffffff);
            position: relative;
            perspective: 1500px;
        }

        .masjid-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://forrira.com/wp-content/uploads/2025/02/bg.png') no-repeat center center/cover;
            opacity: 1.2;
            z-index: -1;
        }

        .login-container {
            position: relative;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 50px;
            width: 420px;
            box-shadow: 15px 15px 50px rgba(0, 0, 0, 0.3), -15px -15px 50px rgba(255, 255, 255, 0.8);
            text-align: center;
            transform: rotateY(10deg) rotateX(10deg);
            transition: transform 0.4s ease-in-out;
        }
        .login-container:hover {
            transform: rotateY(0deg) rotateX(0deg) scale(1.02);
        }

        .login-container .brand-logo {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            margin-bottom: 20px;
            background: #ffffff;
            padding: 10px;
            box-shadow: 10px 10px 30px rgba(0, 0, 0, 0.2), -10px -10px 30px rgba(255, 255, 255, 0.9);
        }

        .login-container input {
            background: #f9f9f9;
            border: 2px solid #bbb;
            padding: 14px;
            border-radius: 12px;
            margin-bottom: 15px;
            color: #333;
            width: 100%;
            font-size: 18px;
            box-shadow: inset 5px 5px 15px rgba(0, 0, 0, 0.1), inset -5px -5px 15px rgba(255, 255, 255, 0.6);
        }

        .login-container input::placeholder {
            color: #888;
        }

        .login-container button {
            background: linear-gradient(135deg, #0088ff, #0055aa);
            border: none;
            padding: 14px;
            border-radius: 12px;
            color: white;
            cursor: pointer;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            width: 100%;
            font-size: 20px;
            box-shadow: 10px 10px 30px rgba(0, 0, 0, 0.3), -10px -10px 30px rgba(255, 255, 255, 0.8);
        }

        .login-container button:active {
            transform: scale(0.95) translateY(4px);
            box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.2), -5px -5px 15px rgba(255, 255, 255, 0.6);
        }

        .login-container a {
            color: #0088ff;
            text-decoration: none;
            font-size: 16px;
        }

        .login-container a:hover {
            text-decoration: underline;
        }

        .progress-bar-container {
            width: 100%;
            background-color: #f3f3f3;
            border-radius: 12px;
            margin-bottom: 15px;
            overflow: hidden;
        }

        .progress-bar {
            height: 20px;
            background-color: #0088ff;
            width: 0;
            border-radius: 12px;
            transition: width 0.5s ease-in-out;
        }
    </style>
</head>

@php
    use Illuminate\Support\Facades\DB;
    use Illuminate\Support\Facades\Http;
    use Illuminate\Support\Facades\Log;
    use Carbon\Carbon;

    $licenceKey = null;
    $username = null;
    $expiredDate = null;
    $remainingDays = 0;
    $progressPercentage = 0;
    $amount = 0;

    $licence = DB::table('licences')->first();
    $site = DB::table('settings')->first();

    if ($licence) {
        $licenceKey = $licence->licence_key;
        $username = $licence->username;
        $amount = '';

        $response = Http::post("https://new.dialabsoftware.com/api/check/licence/key", [
            'licence_key' => $licenceKey,
            'username' => $username,
        ]);

        Log::info('License API Response: ', $response->json() ?? []);

        if ($response->successful()) {
            $licenseData = $response->json() ?? [];

            if (isset($licenseData['data']['created_at'], $licenseData['data']['duration'])) {
                $createdAt = Carbon::parse($licenseData['data']['created_at']);
                $expiredDate = $createdAt->copy()->addDays($licenseData['data']['duration']);
                $today = Carbon::now();
                $amount = isset($licenseData['data']['amount']) ? $licenseData['data']['amount'] : 0;

                if ($today->gt($expiredDate)) {
                    $remainingDays = 0;
                    $progressPercentage = 100;
                } else {
                    $remainingDays = round($today->diffInHours($expiredDate) / 24);
                    $progressPercentage = ($licenseData['data']['duration'] > 0) ? (($licenseData['data']['duration'] - $remainingDays) / $licenseData['data']['duration']) * 100 : 0;
                }
            } else {
                Log::error('Missing keys in API response: ', $licenseData);
            }
        } else {
            Log::error('License API Error: ', $response->json() ?? []);
        }
    }
@endphp

<body>
<div class="masjid-bg"></div>
<div class="login-container">
    @if(isset($site->logo))
        <img src="{{ asset('img/'. $site->logo) }}" class="brand-logo" alt="Logo">
    @else
        <img src="{{ asset('logo.png') }}" class="brand-logo" alt="Logo">
    @endif

    @if($expiredDate)
        @if($remainingDays > 0)
            <p>Your license is valid until <b>{{ $expiredDate->format('Y-m-d') }}</b>. You have <b>{{ $remainingDays }}</b> days remaining.</p>
        @else
            <p style="color: red; font-size:15px;"><b>{{ $expiredDate->format('Y-m-d') }}</b> তারিখ আপনার লাইসেন্সের মেয়াদ শেষ হয়েছে।</p>
        @endif
        <div class="progress-bar-container">
            <div class="progress-bar" id="progress-bar" data-progress="{{ $progressPercentage }}"></div>
        </div>
    @else
        <p style="color: red;">Failed to fetch license details.</p>
    @endif

    @if($remainingDays > 0 || !$licence)
        <form method="POST" action="{{ route('login') }}">
            @csrf
            <input type="text" name="email" class="form-control" placeholder="username" value="" required>
            <input type="password" name="password" class="form-control" placeholder="password" value="" required>
            <button type="submit">Login</button>
        </form>
    @else
        <p style="color: red; font-size: 15px; text-align: left;">
            সম্মানিত গ্রাহক, লাইসেন্স নবায়নের জন্য অনুগ্রহ করে {{ $amount }} টাকা বিকাশ (Send Money) করুন +8801804-909500 নম্বরে। রেফারেন্সে অবশ্যই আপনার ইউজারনেম {{  $username ?? '' }} লিখবেন।
        </p>
        <p style="color: red; font-size: 15px; text-align: left;">
            পেমেন্টের পর লাইসেন্স স্বয়ংক্রিয়ভাবে একটিভ হবে। ধন্যবাদ।
        </p>

        <a href="http://wa.me/+8801804909500"> WhatsApp : +8801804-909500</a>
    @endif
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        let progressBar = document.getElementById("progress-bar");
        let progress = progressBar.getAttribute("data-progress");
        progressBar.style.width = progress + "%";
    });
</script>

</body>
</html>
