@extends('dashboard.master')
@section('title', 'Admit Card')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        .swal-title {
            font-size: 17px;
            color: red;
            padding: 0;
        }

        .swal-text {
            margin-top: 5px !important;
            color: black;
            background-color: white;
            box-shadow: none;
        }

        .swal-modal {
            max-width: 299px;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

        /* Filter area styling */
        .filter-section {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .filter-section label {
            margin-bottom: 5px;
            font-weight: bold;
        }

        .filter-section .form-control {
            height: calc(2.25rem + 2px);
            /* Align with other form controls */
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Admit Card</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        @if(Auth::user()->role_id == 1 || Auth::user()->type == 1 || Auth::user()->canPerm('admitcard.create'))
                        {{-- <a title="Create" href="{{ route('admitcard.create') }}" type="button"
                        class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a> --}}
                    @endif
                        <button type="button" title="Print All" target="_blank"
                            class="btn btn-sm btn-success ml-2 printFilter">
                            <i class="fas fa-print mr-1"></i>
                            Print All
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                {{-- Filter Section --}}
                <div class="card filter-section">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="exam_id">পরীক্ষার নাম:</label>
                                    <select name="exam_id" id="exam_id" class="form-control select2">
                                        <option value="">সকল পরীক্ষা</option>
                                        {{-- এখানে আপনার পরীক্ষার অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="class_id">শ্রেণী:</label>
                                    <select name="class_id" id="class_id" class="form-control select2">
                                        <option value="">সকল শ্রেণী</option>
                                        {{-- এখানে আপনার শ্রেণীর অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                       
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="session_id">শিক্ষাবর্ষ:</label>
                                    <select name="session_id" id="session_id" class="form-control select2">
                                        <option value="">সকল শিক্ষাবর্ষ</option>
                                        {{-- এখানে আপনার শিক্ষাবর্ষের অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                      
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 text-right mt-2">
                                <button type="button" id="filterButton" class="btn btn-info">
                                    <i class="fas fa-filter mr-1"></i> ফিল্টার করুন
                                </button>
                                <button type="button" id="clearFilterButton" class="btn btn-warning ml-2">
                                    <i class="fas fa-times mr-1"></i> ফিল্টার মুছে ফেলুন
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- End Filter Section --}}

                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Exam</th>
                                    <th>Class</th>
                                    <th>Student</th>
                                    <th>Given By</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


        <script>
            $(document).ready(function() {
            

                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: false,
                    serverSide: true,
                    scrollX: true,
                    autoWidth: false,
                    scroller: {
                        loadingIndicator: false
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('admitcard') }}",
                        data: function(d) {
                          
                            d.exam_id = $('#exam_id').val();
                            d.class_id = $('#class_id').val();
                            d.session_id = $('#session_id').val();
                        },
                        type: "get"
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: true,
                            orderable: true
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'exam',
                            name: 'exam'
                        },
                        {
                            data: 'className',
                            name: 'className'
                        },
                        {
                            data: 'student',
                            name: 'student'
                        },
                        {
                            data: 'givenBy',
                            name: 'givenBy'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],

                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Admitcard List',
                            header: true,
                            footer: true,
                        },
                        {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Admitcard',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5],
                                stripHtml: true
                            }
                        },

                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Admitcard List',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility',
                            title: 'Column Visibility',
                            columns: ':not(:first-child)'
                        }
                    ],
                });

                // ফিল্টার বাটনে ক্লিক করলে ডাটাটেবিল রিলোড হবে
                $('#filterButton').on('click', function() {
                    dTable.ajax.reload();
                });

                // ফিল্টার মুছে ফেলার বাটন
                $('#clearFilterButton').on('click', function() {
                    $('#exam_id').val('').trigger('change'); // Select2 ব্যবহার করলে .trigger('change') জরুরি
                    $('#class_id').val('').trigger('change');
                    $('#session_id').val('').trigger('change');
                    dTable.ajax.reload(); // ফিল্টার মুছে ফেলার পর ডাটাটেবিল রিলোড করুন
                });


                 $('.printFilter').on('click', function(e) {
                    e.preventDefault();
                    console.log('clicked');

                    // বর্তমান ফিল্টার ভ্যালুগুলো সংগ্রহ করুন
                    var exam_id = $('#exam_id').val();
                    var class_id = $('#class_id').val();
                    var session_id = $('#session_id').val();

                    // বেস URL তৈরি করুন (আপনার admitcard.printAll রুটের URL)
                    var printUrl = "{{ route('admitcard.printAll') }}";
                    var params = [];

                    // ফিল্টার ভ্যালু থাকলে সেগুলোকে URL প্যারামিটার হিসেবে যোগ করুন
                    if (exam_id) {
                        params.push('exam_id=' + exam_id);
                    }
                    if (class_id) {
                        params.push('class_id=' + class_id);
                    }
                    if (session_id) {
                        params.push('session_id=' + session_id);
                    }

                    // যদি কোনো প্যারামিটার থাকে, তাহলে URL এ যোগ করুন
                    if (params.length > 0) {
                        printUrl += '?' + params.join('&');
                    }

                    // নতুন ট্যাবে প্রিন্ট URL খুলুন
                    window.open(printUrl, '_blank');
                });



                $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                    e.preventDefault();

                    $.ajaxSetup({
                        headers: {
                            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                        }
                    });

                    const url = $(this).data('remote');
                    swal({
                        title: `Are you sure?`,
                        text: "Want to delete this record?",
                        buttons: true,
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                url: url,
                                type: 'get',
                                dataType: 'json',
                                data: {
                                    submit: true,
                                    _method: 'delete',
                                    _token: "{{ csrf_token() }}"
                                }
                            }).always(function(data) {
                                $('#data_table').DataTable().ajax.reload();
                                if (data.success === true) {
                                    toastr.success(data.message, {
                                        positionClass: 'toast-bottom-full-width',
                                    });
                                } else {
                                    toastr.error(data.message, {
                                        positionClass: 'toast-bottom-full-width',
                                    });
                                }
                            });
                        }
                    });
                });

                //toastr.options.timeOut = 300;
                @if (Session::has('success'))
                    toastr.options = {
                        "closeButton": true,
                        "progressBar": true,
                        "timeOut": 1000
                    };
                    toastr.success("{{ session('success') }}");
                @endif

                @if (Session::has('error'))
                    toastr.options = {
                        "closeButton": true,
                        "progressBar": true
                    };
                    toastr.error("{{ session('error') }}");
                @endif
            });
        </script>
    @endpush
@endsection
