<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>All Admit Cards</title>
    <style>
        @page {
            size: A5 landscape;
            margin: 3mm;
        }

        body {
            font-family: 'Noto Serif Bengali', serif;
            background: white;
            margin: 0;
            padding: 0;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    @foreach ($data as $item)
        @php
            $examRouting = \App\Models\ExamRouting::where('class_id', $item->class_id)
                ->where('session_id', $item->session_id)
                ->where('exam_id', $item->exam_id)
                ->with('details.subject')
                ->first();
        @endphp

        @if ($examRouting)
            @include('dashboard.admitcard.exam_routing_print_for_all', [
                'data' => $item,
                'invoice' => $invoice,
                'setting' => $setting,
                'examRouting' => $examRouting,
            ])
        @else
            @include('dashboard.admitcard.print_for_all', [
                'data' => $item,
                'invoice' => $invoice,
                'setting' => $setting,
                'examRouting' => null,
            ])
        @endif

        {{-- @if (!$loop->last)
            <div class="page-break"></div>
        @endif --}}
    @endforeach

    <script>
        window.onload = () => {
            setTimeout(() => window.print(), 500);
        };
    </script>
</body>
</html>
