@extends('dashboard.master')
@section('title', 'Student Attendance')
@push('css')
<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Student Attendance</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('student.attendance.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Date & Day</th>
                                <th>User</th>
                                <th>Entry Time</th>
                                <th>Exit Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($records as $key => $record)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ \Carbon\Carbon::parse($record->date)->format('M d, Y, l') }}</td>
                                <td>
                                    {{ $record->user->name ?? '' }}
                                    <br>
                                    {{ $record->user->email ?? '' }}
                                    <br>
                                    {{ $record->user->phone ?? '' }}
                                </td>
                                <td>
                                    @if(!empty($record->entry_time))
                                    {{ \Carbon\Carbon::parse($record->entry_time)->format('h:i:s a') }}
                                    @endif
                                </td>
                                <td>
                                    @if(!empty($record->exit_time))
                                    {{ \Carbon\Carbon::parse($record->exit_time)->format('h:i:s a') }}
                                    @endif
                                </td>


                                <td>
                                    @if($record->status == 1)
                                        <span class="badge bg-success">Present</span>
                                    @elseif($record->status == 2)
                                        <span class="badge bg-danger">Absent</span>
                                    @elseif($record->status == 3)
                                        <span class="badge bg-warning">Late</span>
                                    @elseif($record->status == 4)
                                        <span class="badge bg-warning">Personal Leave</span>
                                    @else
                                     <span class="badge bg-danger">Absent</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>

<script>
$(document).ready(function() {
    $('#table').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "responsive": true,
        "order": 1,
    });
});
</script>
@endpush
@endsection
