@extends('dashboard.master')

@section('css')
    <style>
       
        @media print {
            body {
                margin: 0;
                padding: 0;
                font-family: Arial, sans-serif;
            }

            /* Ensure the page is printed in landscape */
            @page {
                size: landscape;
            }

            .container-fluid {
                max-width: 100%;
                margin: 0 auto;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
                page-break-before: always;
            }

            th,
            td {
                text-align: center;
                padding: 8px;
                border: 1px solid #ddd;
            }

            th {
                background-color: #f2f2f2;
                font-weight: bold;
            }

            .header-info {
                margin-bottom: 20px;
                font-size: 14px;
            }

            .header-info div {
                margin-bottom: 5px;
            }

            /* Show all elements for print */
            .content-wrapper,
            .content-header,
            .page-title-wrapper,
            .page-title-actions {
                display: block !important;
            }

            /* Hide the Print button in the print view */
            .printButton {
                display: none !important;
            }

            footer {
                display: none !important;
            }
        }
    </style>
@endsection

@section('content')
<style>
     .bg-footer-custom {
            display: none !important;
        }
</style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Student Attendance</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('teacher.attendance.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                        <button onclick="window.print()" class="printButton btn btn-sm btn-secondary">Print</button>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <h3>Attendance for {{ \Carbon\Carbon::parse($month)->format('F Y') }}</h3>

                        <!-- Total Counts for Each Status -->
                        <div class="header-info">
                            <div><strong>প = উপস্থিত (Present)</strong></div>
                            <div><strong>এ = অনুপস্থিত (Absent)</strong></div>
                            <div><strong>দে = দেরিতে উপস্থিত (Late Present)</strong></div>
                            <div><strong>ছু = ছুটি (Holiday)</strong></div>
                            <div><strong>অ = অর্ধেক দিন (Half Day)</strong></div>
                        </div>

                        <!-- Table Layout -->
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th rowspan="2">Student Name</th>
                                        @for ($i = 1; $i <= 31; $i++)
                                            <th>{{ $i }}</th> <!-- Each day as a column -->
                                        @endfor
                                        <th rowspan="2">প</th>
                                        <th rowspan="2">এ</th>
                                        <th rowspan="2">দে</th>
                                        <th rowspan="2">ছু</th>
                                        <th rowspan="2">অ</th>
                                    </tr>
                                    <tr>
                                        @for ($i = 1; $i <= 31; $i++)
                                            <th></th> <!-- Empty for attendance marking -->
                                        @endfor
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($attendanceData as $attendance)
                                   
                                        <!-- Loop through attendance records -->
                                        <tr>
                                            <td>{{ $attendance->students->name }}</td> <!-- Display teacher's name -->

                                            @php
                                                // Initialize the counters for each status
                                                $presentCount = 0;
                                                $absentCount = 0;
                                                $latePresentCount = 0;
                                                $holidayCount = 0;
                                                $halfDayCount = 0;
                                               $attendanceMonth = \Carbon\Carbon::parse($attendance->date)->format('Y-m'); 
                                            @endphp
                                            @for ($i = 1; $i <= 31; $i++)  <!-- Loop through 31 days -->
                                            <td>
                                                    @php
                                                        // Check if the attendance record exists for the specific date
                                                        $attendanceStatus = $attendance->whereNull('teacher_id')->firstWhere(
                                                            'date',
                                                            \Carbon\Carbon::parse("{$attendanceMonth}-{$i}")
                                                        );
                                                        @endphp
                                                    @if ($attendanceStatus)
                                                   
                                                        @switch($attendanceStatus->status)
                                                            @case(1)
                                                                {{ __('প') }} <!-- Present -->
                                                                @php $presentCount++; @endphp
                                                                @break

                                                            @case(2)
                                                                {{ __('এ') }} <!-- Absent -->
                                                                @php $absentCount++; @endphp
                                                                @break

                                                            @case(3)
                                                                {{ __('দে') }} <!-- Late Present -->
                                                                @php $latePresentCount++; @endphp
                                                                @break

                                                            @case(4)
                                                                {{ __('ছু') }} <!-- Holiday -->
                                                                @php $holidayCount++; @endphp
                                                                @break

                                                            @case(5)
                                                                {{ __('অ') }} <!-- Half Day -->
                                                                @php $halfDayCount++; @endphp
                                                                @break

                                                            @default
                                                                <!-- Empty cell for no record -->
                                                        @endswitch
                                                    @else
                                                        <!-- No attendance data for this day -->
                                                    @endif
                                                </td>
                                            @endfor

                                            <td>{{ $presentCount }}</td> <!-- Total Present days -->
                                            <td>{{ $absentCount }}</td> <!-- Total Absent days -->
                                            <td>{{ $latePresentCount }}</td> <!-- Total Late Present days -->
                                            <td>{{ $holidayCount }}</td> <!-- Total Holiday days -->
                                            <td>{{ $halfDayCount }}</td> <!-- Total Half Day days -->
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Print Button -->
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
