@extends('dashboard.master')
@section('title', 'Student Attendance')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Student Attendance</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('student.attendance.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">

                        <!-- Month Dropdown -->
                        <form id="attendance_filter_form">
                            <div class="row">
                                <div class="col-sm-3">
                                    <select id="month_dropdown" class="form-control">
                                        <option value="">Select Month</option>
                                        @foreach ($distinctMonths as $month)
                                            <option value="{{ $month->month }}">
                                                {{ \Carbon\Carbon::parse($month->month . '-01')->format('F Y') }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <select id="class_dropdown" class="form-control">
                                        <option value="">Select Class</option>
                                        @foreach ($distinctClasses as $class)
                                            <option value="{{ $class->class_id }}">{{ $class->stuclass->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-sm-3">
                                    <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                                </div>
                                <div class="col-sm-3">
                                    <!-- Print Button -->
                                    <button type="button" id="printButton"
                                        class="btn btn-sm btn-danger printAttendenceBUtton">Print Attendance</button>
                                </div>
                            </div>
                        </form>

                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Class</th>
                                    <th>Student</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: false,
                    scrollX: true,
                    autoWidth: false,
                    serverSide: true,
                    scroller: {
                        loadingIndicator: false
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('student.attendance') }}",
                        type: "get",
                        data: function(d) {
                            d.month = $('#month_dropdown').val(); 
                            d.class = $('#class_dropdown').val(); // Send selected month
                        }
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: false
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'stuclass',
                            name: 'stuclass'
                        },
                        {
                            data: 'student',
                            name: 'student'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Student Attendance List',
                            header: true,
                            footer: true,
                        },

                        {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Student Attendance',
                            header: true,
                            footer: true,
                            exportOptions: {
                                columns: [0, 1, 2, 3],
                                stripHtml: true
                            }
                        },

                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Student Attendance List',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility',
                            title: 'Column Visibility',
                            columns: ':not(:first-child)'
                        }
                    ],
                });

                $('#attendance_filter_form').on('submit', function(e) {
                    e.preventDefault();
                    dTable.ajax.reload(); // Reload the data table with the selected month
                });

                // Print Button Click Event
                $('.printAttendenceBUtton').on('click', function(e) {
                    console.log('Print button clicked');
                    e.preventDefault();
                    var selectedMonth = $('#month_dropdown').val(); // Get the selected month
                    var selectedClass = $('#class_dropdown').val();
                    if (selectedMonth && selectedClass) {
                       window.open(
    "{{ route('student.attendance.print', [':month', ':class']) }}"
        .replace(':month', selectedMonth)
        .replace(':class', selectedClass), 
    '_blank'
);
                    } else {
                        alert('Please select a month and class');
                    }
                });
            });

            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();

                const url = $(this).data('remote');
                swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                submit: true,
                                _method: 'delete',
                                _token: "{{ csrf_token() }}"
                            }
                        }).always(function(data) {
                            $('#data_table').DataTable().ajax.reload();
                            if (data.success === true) {
                                toastr.success(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            } else {
                                toastr.error(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            }
                        });
                    }
                });

                // Filter form submit event

            });

            //  toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
