@extends('dashboard.master')
@section('title', 'Student Attendance Edit')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .status-green {
        color: green !important;
    }

    .status-red {
        color: red !important;
    }

    .status-yellow {
        color: yellow !important;
    }

    .status-gray {
        color: gray !important;
    }

    .status-orange {
        color: orange !important;
    }
    #message {
        color: red !important;
    }

</style>
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Attendance Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.attendance.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}" @if($class->id == $data->class_id) selected @endif>{{ $class->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}" @if($session->id == $data->session_id) selected @endif>{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <div class="d-flex">
                                        <input type="text" name="date" id="date" value="{{ \Carbon\carbon::parse($data->date)->format('Y-m-d') }}" class="form-control" placeholder="date" required>
                                        <button title="Find" id="button" type="button" class="btn btn-primary ml-2">Find</button>
                                    </div>

                                    @if (session('error'))
                                        <div class="alert alert-danger mt-2">
                                            {{ session('error') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <hr>
                        <span id="message"></span>
                        <div class="attendance-status-section">
                            <div class="box-body">
                                <div class="mailbox-controls">
                                    <div class="row">
                                        <div class="col-md-12 d-flex justify-content-between align-items-center">
                                            <div class="form-group d-flex align-items-center">
                                                <span for="attendance_type" class="mr-3">Set attendance for all students as:</span>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_present" value="all_present" id="all_present" autocomplete="off">
                                                    <label for="all_present" style="font-weight: normal;">All Present</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_late" value="all_late" id="all_late" autocomplete="off">
                                                    <label for="all_late" style="font-weight: normal;">All Late</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_absent" value="all_absent" id="all_absent" autocomplete="off">
                                                    <label for="all_absent" style="font-weight: normal;">All Absent</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_holiday" value="all_holiday" id="all_holiday" autocomplete="off">
                                                    <label for="all_holiday" style="font-weight: normal;">All Holiday</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_halfday" value="all_halfday" id="all_halfday" autocomplete="off">
                                                    <label for="all_halfday" style="font-weight: normal;">All Half Day</label>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <button type="submit" name="search" value="saveattendence" id="saveattendence" class="btn btn-primary btn-sm">
                                                    <i class="fa fa-save"></i> Update Attendance
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div><hr>

                                <div class="table-responsive ptt10">
                                    <table class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Reg No</th>
                                                <th>Attendance</th>
                                            </tr>
                                        </thead>
                                        <tbody id="student_data">
                                            @foreach ($students as $student)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $student->students->name }} <br> {{ $student->students->roll_no ?? '' }}</td>
                                                <td>{{ $student->students->register_no ?? '' }}</td>
                                                <td>
                                                    <input type="hidden" name="student_id[{{ $student->id }}]" value="{{ $student->student_id }}">
                                                    <div class="form-group d-flex align-items-center">
                                                        @php $statuses = [1 => 'Present', 2 => 'Absent', 3 => 'Late', 4 => 'Holiday', 5 => 'Half Day']; @endphp
                                                        @foreach($statuses as $value => $label)
                                                            @php $id = "status_{$label}_{$student->id}"; @endphp
                                                            <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                <input type="radio" name="status[{{ $student->id }}]" class="{{ strtolower(str_replace(' ', '', $label)) }}" value="{{ $value }}" id="{{ $id }}" data-status="{{ $student->status }}" {{ $student->status == $value ? 'checked' : '' }}>
                                                                <label for="{{ $id }}">{{ $label }}</label>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$(function () {
    $('#date').datepicker({ dateFormat: 'yy-mm-dd' });

    const originalClassId = '{{ $data->class_id }}';
    const originalSessionId = '{{ $data->session_id }}';
    const originalDate = '{{ \Carbon\Carbon::parse($data->date)->format('Y-m-d') }}';

    function refreshColors() {
        $('input[name^="status["][type="radio"]:checked').each(function () {
            const studentId = $(this).attr('id').split('_').pop();
            const status = parseInt($(this).val());
            updateStatusColor(studentId, status);
        });
    }

    function updateStatusColor(studentId, status) {
        const statusClassMap = {
            1: 'status-green',
            2: 'status-red',
            3: 'status-orange',
            4: 'status-gray',
            5: 'status-yellow'
        };

        const all = ['status-green', 'status-red', 'status-orange', 'status-gray', 'status-yellow'];
        all.forEach(cls => {
            $('#status_Present_' + studentId).parent().removeClass(cls);
            $('#status_Absent_' + studentId).parent().removeClass(cls);
            $('#status_Late_' + studentId).parent().removeClass(cls);
            $('#status_Holiday_' + studentId).parent().removeClass(cls);
            $('#status_HalfDay_' + studentId).parent().removeClass(cls);
        });

        $('input[name="status[' + studentId + ']"]:checked').parent().addClass(statusClassMap[status]);
    }

    function updateAttendanceButtons() {
        const counts = {1: 0, 2: 0, 3: 0, 4: 0, 5: 0};
        const total = $('input[name^="status["][type="radio"]:checked').length;

        $('input[name^="status["][type="radio"]:checked').each(function () {
            counts[$(this).val()]++;
        });

        $('#all_present').prop('checked', counts[1] === total);
        $('#all_absent').prop('checked', counts[2] === total);
        $('#all_late').prop('checked', counts[3] === total);
        $('#all_holiday').prop('checked', counts[4] === total);
        $('#all_halfday').prop('checked', counts[5] === total);
    }

    function loadAttendanceData() {
        const date = $('#date').val();
        const class_id = $('#class_id').val();
        const session_id = $('#session_id').val();
        const _token = $('meta[name="csrf-token"]').attr('content');

        if (!class_id || !session_id || !date) return;

        $.ajax({
            url: "{{ route('student.find') }}",
            type: "POST",
            data: {
                date, class_id, session_id, _token
            },
            success: function(response) {
                if (response.success === false) {
                    $('#student_data').html('');
                    $('#message').show().text(response.message);
                    $('.attendance-status-section').hide();
                } else {
                    $('#student_data').html(response.html);
                    $('#message').hide();
                    $('.attendance-status-section').show();
                    refreshColors();
                    updateAttendanceButtons();
                }
            },
            error: function() {
                alert('Error fetching attendance data.');
            }
        });
    }

    function checkAndAutoLoad() {
        const class_id = $('#class_id').val();
        const session_id = $('#session_id').val();
        const date = $('#date').val();

        if (!class_id || !session_id || !date) return;

        if (
            class_id !== originalClassId ||
            session_id !== originalSessionId ||
            date !== originalDate
        ) {
            loadAttendanceData();
        } else {
            $('.attendance-status-section').show();
            $('#message').hide();
        }
    }

    $('#button').on('click', function (e) {
        e.preventDefault();
        loadAttendanceData();
    });

    $('#class_id, #session_id, #date').on('change', function () {
        checkAndAutoLoad();
    });

    refreshColors();
    updateAttendanceButtons();
});

@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif

</script>
@endpush

@endsection
