@extends('dashboard.master')
@section('title', 'Teacher Attendance Edit')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .status-green {
        color: green !important;
    }

    .status-red {
        color: red !important;
    }

    .status-yellow {
        color: yellow !important;
    }

    .status-gray {
        color: gray !important;
    }

    .status-orange {
        color: orange !important;
    }

    @media print {
        body * {
            visibility: hidden;
        }

        #printArea, #printArea * {
            visibility: visible;
        }

        #printArea {
            position: relative;
            left: 0;
            top: 0;
            width: 100%;
        }
        table {
            width: 100% !important;
            page-break-inside: auto;
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        @page {
            size: A4 portrait;
            margin: 10mm;
        }

        thead {
            display: table-header-group;
        }

        tfoot {
            display: table-footer-group;
        }

        /* body {
            margin: 0;
            padding: 0;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        } */

        .print-header,
        .print-footer {
            display: block;
            width: 100%;
            page-break-inside: avoid;
        }

        .print-header{

        }
        .print-footer{

        }

        .print-body {
            padding: 20px 30px;
        }
        table {
            width: 100% !important;
            page-break-inside: auto;
        }
        .teacher-row {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        .no-print {
            display: none !important;
        }

        .print-header img,
        .print-footer img {
            width: 100% !important;
            height: auto !important;
            display: block;
        }
    }

    .print-header, .print-footer {
        display: none;
    }

    @media print {
        .print-header, .print-footer {
            display: block;
        }
    }

    .print-image {
        width: 100%;
        height: auto;
        display: block;
    }
</style>
@endpush

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Teacher Attendance Edit</b></span>
                </div>
                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div id="printArea" class="card">
                <div class="card-body">
                    <form action="{{ route('teacher.attendance.update', $data->id) }}" method="POST" class="form_attendence">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="date" value="{{ \Carbon\carbon::parse($data->date)->format('Y-m-d') }}">
                      

                        <div class="table-responsive ptt10">
                            <table class="table table-bordered table-striped data-table table-hover">
                                <thead>

                                    <tr>
                                        <td colspan="4">
                                            <div class="print-header">
                                                <img src="{{ asset('img/' . ($invoiceDesign->invoice_header ?? '')) }}" alt="invoice-header" class="print-image">
                                            </div>
                                        </td>
                                    </tr>


                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="4">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h6 class="d-flex align-items-center">
                                                        <i class="fa fa-calendar mr-2"></i> হাজিরা তারিখ:
                                                        <input type="text" name="date" id="date" class="form-control col-md-2 ml-2" value="{{ \Carbon\carbon::parse($data->date)->format('Y-m-d') }}">
                                                    </h6>
                                                </div>
                                                <div class="col-md-12 d-flex justify-content-between align-items-center">
                                                    <div class="form-group d-flex align-items-center">
                                                        <span class="mr-3">সকল শিক্ষকের জন্য উপস্থিতি নির্ধারণ করুন:</span>
                                                        @foreach(['present' => 'সব উপস্থিত', 'late' => 'সব দেরিতে উপস্থিতি', 'absent' => 'সব অনুপস্থিত', 'holiday' => 'সব ছুটি', 'halfday' => 'অর্ধদিবস ছুটি'] as $key => $label)
                                                            <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                <input type="radio" name="attendance_status" class="all_{{ $key }}" value="all_{{ $key }}" id="all_{{ $key }}">
                                                                <label for="all_{{ $key }}" style="font-weight: normal;">{{ $label }}</label>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                    <div style="display: flex; justify-content: end; gap: 10px;">
                                                    <div class="form-group no-print">
                                                        <button type="submit" class="btn btn-primary btn-sm">
                                                            <i class="fa fa-save"></i> Update Attendance
                                                        </button>
                                                    </div>
                                                    <div class="text-right mb-3 no-print">
                                                        <button type="button" class="btn btn-secondary btn-sm"
                                                            onclick="printAttendance()">
                                                            <i class="fa fa-print"></i> Print Attendance
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th>নাম</th>
                                        <th>রেজিস্ট্রেশন নম্বর</th>
                                        <th>উপস্থিতি</th>
                                    </tr>
                                    @foreach ($teachers as $teacher)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $teacher->teacher->name ?? '' }} <br> {{ $teacher->teacher->phone ?? '' }}</td>
                                        <td>{{ $teacher->teacher->reg_no ?? '' }}</td>
                                        <td>
                                            <input type="hidden" name="teacher_id[{{ $teacher->id }}]" value="{{ $teacher->teacher_id }}">
                                            <div class="form-group d-flex align-items-center">
                                                @php $statuses = [1 => 'উপস্থিত', 2 => 'অনুপস্থিত', 3 => 'বিলম্বিত', 4 => 'ছুটি', 5 => 'অর্ধ দিবস']; @endphp
                                                @foreach($statuses as $value => $label)
                                                    @php $id = "status_{$label}_{$teacher->id}"; @endphp
                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                        <input type="radio" name="status[{{ $teacher->id }}]" class="{{ strtolower(str_replace(' ', '', $label)) }}" value="{{ $value }}" id="{{ $id }}" data-status="{{ $teacher->status }}" {{ $teacher->status == $value ? 'checked' : '' }}>
                                                        <label for="{{ $id }}">{{ $label }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                      <td colspan="6">
                                          <div class="print-footer">
                                              <img src="{{ asset('img/' . ($invoiceDesign->invoice_footer ?? '')) }}" alt="invoice-footer" class="print-image">
                                          </div>
                                      </td>
                                    </tr>
                                  </tfoot>
                            </table>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>
$(function () {
    $('#date').datepicker({ dateFormat: 'yy-mm-dd' });

    function updateAttendanceButtons() {
        var statusCounters = { 1: 0, 2: 0, 3: 0, 4: 0, 5: 0 };
        var total = $('input[name^="status["][type="radio"]:checked').length;

        $('input[name^="status["][type="radio"]:checked').each(function () {
            let status = $(this).val();
            statusCounters[status]++;
        });

        $('#all_present').prop('checked', statusCounters[1] === total);
        $('#all_absent').prop('checked', statusCounters[2] === total);
        $('#all_late').prop('checked', statusCounters[3] === total);
        $('#all_holiday').prop('checked', statusCounters[4] === total);
        $('#all_halfday').prop('checked', statusCounters[5] === total);
    }

    function updateStatusColor(teacherId, status) {
        const statusClasses = ['status-green', 'status-red', 'status-orange', 'status-gray', 'status-yellow'];
        const statusClassMap = {
            1: 'status-green',
            2: 'status-red',
            3: 'status-orange',
            4: 'status-gray',
            5: 'status-yellow'
        };

        // Remove all status classes
        statusClasses.forEach(cls => {
            $('#status_Present_' + teacherId).parent().removeClass(cls);
            $('#status_Absent_' + teacherId).parent().removeClass(cls);
            $('#status_Late_' + teacherId).parent().removeClass(cls);
            $('#status_Holiday_' + teacherId).parent().removeClass(cls);
            $('#status_Half Day_' + teacherId).parent().removeClass(cls);
        });

        // Apply class to selected
        const selectedInput = $('input[name="status[' + teacherId + ']"]:checked');
        selectedInput.parent().addClass(statusClassMap[status]);
    }

    function refreshColors() {
        $('input[name^="status["][type="radio"]:checked').each(function () {
            const teacherId = $(this).attr('id').split('_').pop();
            const status = parseInt($(this).val());
            updateStatusColor(teacherId, status);
        });
    }

    // Initial color and button setup
    refreshColors();
    updateAttendanceButtons();

    // On individual change
    $('.present, .absent, .late, .holiday, .halfday').on('change', function () {
        const teacherId = $(this).attr('id').split('_').pop();
        const status = parseInt($(this).val());
        updateStatusColor(teacherId, status);
        updateAttendanceButtons();
    });

    // On "all" change
    $('input[name="attendance_status"]').on('change', function () {
        const selected = $(this).val();

        const map = {
            all_present: 1,
            all_absent: 2,
            all_late: 3,
            all_holiday: 4,
            all_halfday: 5
        };

        const status = map[selected];

        $('input[name^="status["][type="radio"][value="' + status + '"]').each(function () {
            $(this).prop('checked', true);
            const teacherId = $(this).attr('id').split('_').pop();
            updateStatusColor(teacherId, status);
        });

        updateAttendanceButtons();
    });
});
function printAttendance() {
        window.print(); // ✅ Simple and safe
    }
</script>
@endpush
