@extends('dashboard.master')
@section('title', 'Teacher Attendance Create')

@push('css')
<style>
    .status-green { color: green !important; }
    .status-red { color: red !important; }
    .status-yellow { color: yellow !important; }
    .status-gray { color: gray !important; }
    .status-orange { color: orange !important; }

    @media print {
        body * {
            visibility: hidden;
        }

        #printArea, #printArea * {
            visibility: visible;
        }

        #printArea {
            position: relative;
            left: 0;
            top: 0;
            width: 100%;
        }
        table {
            width: 100% !important;
            page-break-inside: auto;
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        @page {
            size: A4 portrait;
            margin: 10mm;
        }

        thead {
            display: table-header-group;
        }

        tfoot {
            display: table-footer-group;
        }

        /* body {
            margin: 0;
            padding: 0;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        } */

        .print-header,
        .print-footer {
            display: block;
            width: 100%;
            page-break-inside: avoid;
        }

        .print-header{

        }
        .print-footer{

        }

        .print-body {
            padding: 20px 30px;
        }
        table {
            width: 100% !important;
            page-break-inside: auto;
        }
        .teacher-row {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        .no-print {
            display: none !important;
        }

        .print-header img,
        .print-footer img {
            width: 100% !important;
            height: auto !important;
            display: block;
        }
    }

    .print-header, .print-footer {
        display: none;
    }

    @media print {
        .print-header, .print-footer {
            display: block;
        }
    }

    .print-image {
        width: 100%;
        height: auto;
        display: block;
    }
</style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Teacher Attendance Create</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div id="printArea" class="card">

                    <div class="card-body print-body">

                        <div class="box-body">

                            <form action="{{ route('teacher.attendance.store') }}" method="POST" class="form_attendence">
                                @csrf

                                <input type="hidden" name="date" value="{{ $date ?? '' }}">



                                <div class="table-responsive ptt10">
                                    <table id="data_table"
                                        class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <td colspan="4">
                                                    <div class="print-header">
                                                        <img src="{{ asset('img/' . ($invoiceDesign->invoice_header ?? '')) }}" alt="invoice-header" class="print-image">
                                                    </div>
                                                </td>
                                            </tr>



                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="4">

                                                        <div class="no-print">
                                                            <h5> শিক্ষকদের তালিকা</h5>
                                                        <hr>
                                                        </div>
                                                        <div class="box-header with-border">
                                                            <h6 class="box-title"><i class="fa fa-canader"></i> তারিখ: <b>{{ $date ?? '' }}</b></h6>
                                                        </div>

                                                    <hr>
                                                    <div class="mailbox-controls">
                                                        <div class="row">

                                                            <div class="col-md-12 d-flex justify-content-between align-items-center">

                                                                <div class="form-group d-flex align-items-center">
                                                                    <span for="attendance_type" class="mr-3">সকল শিক্ষকের জন্য উপস্থিতি
                                                                        নির্ধারণ করুন:</span>

                                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                        <input type="radio" name="attendance_status" class="all_present"
                                                                            value="all_present" id="all_present" autocomplete="off">
                                                                        <label for="all_present" style="font-weight: normal;">সব উপস্থিত</label>
                                                                    </div>

                                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                        <input type="radio" name="attendance_status" class="all_late"
                                                                            value="all_late" id="all_late" autocomplete="off">
                                                                        <label for="all_late" style="font-weight: normal;">সব দেরিতে
                                                                            উপস্থিতি</label>
                                                                    </div>

                                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                        <input type="radio" name="attendance_status" class="all_absent"
                                                                            value="all_absent" id="all_absent" autocomplete="off">
                                                                        <label for="all_absent" style="font-weight: normal;">সব
                                                                            অনুপস্থিত</label>
                                                                    </div>

                                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                        <input type="radio" name="attendance_status" class="all_holiday"
                                                                            value="all_holiday" id="all_holiday" autocomplete="off">
                                                                        <label for="all_holiday" style="font-weight: normal;">সব ছুটি</label>
                                                                    </div>

                                                                    <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                        <input type="radio" name="attendance_status" class="all_halfday"
                                                                            value="all_halfday" id="all_halfday" autocomplete="off">
                                                                        <label for="all_halfday" style="font-weight: normal;">অর্ধদিবস
                                                                            ছুটি</label>
                                                                    </div>


                                                                </div>

                                                               <div style="display: flex; justify-content: end; gap: 10px;">
                                                                <div class="form-group">
                                                                    <button type="submit" name="search" value="saveattendence"
                                                                        id="saveattendence" class="btn btn-primary btn-sm no-print">
                                                                        <i class="fa fa-save"></i> Save Attendance
                                                                    </button>
                                                                </div>
                                                                <div class="text-right mb-3 no-print">
                                                                    <button type="button" class="btn btn-secondary btn-sm"
                                                                        onclick="printAttendance()">
                                                                        <i class="fa fa-print"></i> Print Attendance
                                                                    </button>
                                                                </div>
                                                               </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>#</th>
                                                <th>নাম</th>
                                                <th>রেজিস্ট্রেশন নম্বর</th>
                                                <th>উপস্থিতি</th>
                                            </tr>
                                            @foreach ($teachers as $teacher)
                                            <tr class="teacher-row">
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $teacher->name }} <br> {{ $teacher->phone ?? '' }}</td>
                                                    <td>{{ $teacher->reg_no ?? '' }}</td>
                                                    <td>
                                                        <input type="hidden" name="teacher_id[]"
                                                            value="{{ $teacher->id }}">
                                                        <div class="form-group d-flex align-items-center">

                                                            <div class="form-group d-flex align-items-center">
                                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                    <input type="radio"
                                                                        name="status[{{ $teacher->id }}]"
                                                                        class="present status-green" value="1"
                                                                        id="status_present_{{ $teacher->id }}"
                                                                        data-status="{{ $teacher->attendance_status }}"
                                                                        autocomplete="off" required>
                                                                    <label for="status_present_{{ $teacher->id }}"
                                                                        style="font-weight: normal;">উপস্থিত</label>
                                                                </div>

                                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                    <input type="radio"
                                                                        name="status[{{ $teacher->id }}]"
                                                                        class="absent status-red" value="2"
                                                                        id="status_absent_{{ $teacher->id }}"
                                                                        data-status="{{ $teacher->attendance_status }}"
                                                                        autocomplete="off">
                                                                    <label for="status_absent_{{ $teacher->id }}"
                                                                        style="font-weight: normal;">অনুপস্থিত</label>
                                                                </div>

                                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                    <input type="radio"
                                                                        name="status[{{ $teacher->id }}]" class="late"
                                                                        value="3"
                                                                        id="status_late_{{ $teacher->id }}"
                                                                        data-status="{{ $teacher->attendance_status }}"
                                                                        autocomplete="off">
                                                                    <label for="status_late_{{ $teacher->id }}"
                                                                        style="font-weight: normal;">বিলম্বিত</label>
                                                                </div>

                                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                    <input type="radio"
                                                                        name="status[{{ $teacher->id }}]"
                                                                        class="holiday" value="4"
                                                                        id="status_holiday_{{ $teacher->id }}"
                                                                        data-status="{{ $teacher->attendance_status }}"
                                                                        autocomplete="off">
                                                                    <label for="status_holiday_{{ $teacher->id }}"
                                                                        style="font-weight: normal;">ছুটি</label>
                                                                </div>

                                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                                    <input type="radio"
                                                                        name="status[{{ $teacher->id }}]"
                                                                        class="halfday" value="5"
                                                                        id="status_halfday_{{ $teacher->id }}"
                                                                        data-status="{{ $teacher->attendance_status }}"
                                                                        autocomplete="off">
                                                                    <label for="status_halfday_{{ $teacher->id }}"
                                                                        style="font-weight: normal;">অর্ধ দিবস</label>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </td>

                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                          <tr>
                                            <td colspan="6">
                                                <div class="print-footer">
                                                    <img src="{{ asset('img/' . ($invoiceDesign->invoice_footer ?? '')) }}" alt="invoice-footer" class="print-image">
                                                </div>
                                            </td>
                                          </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </form>
                        </div>

                    </div>
                    {{-- @dd(asset('img/1747633567Screenshot_7.png')) --}}

                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {

                function updateAttendanceButtons() {
                    var allPresentChecked = true;
                    var allLateChecked = true;
                    var allAbsentChecked = true;
                    var allHolidayChecked = true;
                    var allHalfdayChecked = true;

                    $('.present').each(function() {
                        var teacherId = $(this).attr('id').split('_')[2];
                        var status = $('#status_present_' + teacherId).data('status');
                        updateStatusColor(teacherId, status);

                        if (status != 1) {
                            allPresentChecked = false;
                        }

                        if (status != 3) {
                            allLateChecked = false;
                        }

                        if (status != 2) {
                            allAbsentChecked = false;
                        }

                        if (status != 4) {
                            allHolidayChecked = false;
                        }

                        if (status != 5) {
                            allHalfdayChecked = false;
                        }
                    });

                    $('#all_present').prop('checked', allPresentChecked);
                    $('#all_late').prop('checked', allLateChecked);
                    $('#all_absent').prop('checked', allAbsentChecked);
                    $('#all_holiday').prop('checked', allHolidayChecked);
                    $('#all_halfday').prop('checked', allHalfdayChecked);
                }

                function updateStatusColor(teacherId, status) {
                    var statusClass = '';
                    var color = '';

                    switch (status) {
                        case 1:
                            statusClass = 'status-green';
                            color = 'green';
                            break;
                        case 2:
                            statusClass = 'status-red';
                            color = 'red';
                            break;
                        case 3:
                            statusClass = 'status-orange';
                            color = 'orange';
                            break;
                        case 4:
                            statusClass = 'status-gray';
                            color = 'gray';
                            break;
                        case 5:
                            statusClass = 'status-yellow';
                            color = 'yellow';
                            break;
                    }

                    $('#status_present_' + teacherId).parent().addClass(statusClass);
                    $('#status_absent_' + teacherId).parent().addClass(statusClass);
                    $('#status_late_' + teacherId).parent().addClass(statusClass);
                    $('#status_holiday_' + teacherId).parent().addClass(statusClass);
                    $('#status_halfday_' + teacherId).parent().addClass(statusClass);
                }

                updateAttendanceButtons();

                $('.present, .absent, .late, .holiday, .halfday').on('change', function() {
                    updateAttendanceButtons();
                });

                $('input[name="attendance_status"]').on('change', function() {
                    var selectedValue = $(this).val();

                    if (selectedValue === 'all_present') {
                        $('.present').prop('checked', true);
                        $('.absent').prop('checked', false);
                        $('.late').prop('checked', false);
                        $('.holiday').prop('checked', false);
                        $('.halfday').prop('checked', false);
                    } else if (selectedValue === 'all_late') {
                        $('.present').prop('checked', false);
                        $('.absent').prop('checked', false);
                        $('.late').prop('checked', true);
                        $('.holiday').prop('checked', false);
                        $('.halfday').prop('checked', false);
                    } else if (selectedValue === 'all_absent') {
                        $('.present').prop('checked', false);
                        $('.absent').prop('checked', true);
                        $('.late').prop('checked', false);
                        $('.holiday').prop('checked', false);
                        $('.halfday').prop('checked', false);
                    } else if (selectedValue === 'all_holiday') {
                        $('.present').prop('checked', false);
                        $('.absent').prop('checked', false);
                        $('.late').prop('checked', false);
                        $('.holiday').prop('checked', true);
                        $('.halfday').prop('checked', false);
                    } else if (selectedValue === 'all_halfday') {
                        $('.present').prop('checked', false);
                        $('.absent').prop('checked', false);
                        $('.late').prop('checked', false);
                        $('.holiday').prop('checked', false);
                        $('.halfday').prop('checked', true);
                    }
                });



            });

            function printAttendance() {
        window.print(); // ✅ Simple and safe
    }
        </script>
    @endpush
@endsection
