@extends('dashboard.master')
@section('title', 'Boarding Cost')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Boarding Cost</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('boarding.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Receipt No<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no" value="{{ $receipt_no }}" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ now()->format('d/m/Y') }}" class="form-control" placeholder="date" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Fund<span class="text-red">*</span></label>
                                    <input type="text" class="form-control" value="{{ $fund->name ?? '' }}" readonly>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Amount<span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control" placeholder="amount" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Bazar By<span class="text-red">*</span></label>
                                    <input type="text" name="bazar_by" id="bazar_by" value="{{ old('bazar_by') }}" class="form-control" placeholder="bazar by">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Bazar List</label>
                                    <textarea name="bazar_list" id="bazar_list" cols="2" rows="2" class="form-control">{{ old('bazar_list') }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ old('note') }}</textarea>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>


@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'dd/m/yy'
    });
});
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection

