@extends('dashboard.master')
@section('title', 'Edit Class')

@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Class</b>
					</span>
				</div>
                <div class="page-title-actions">
					<a title="Back" href="{{ route('class.index') }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('class.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="department_name">Class Name<span class="text-red">*</span></label>

                                    <input type="text" name="department_name" id="department_name" value="{{ $data->department_name }}" class="form-control @error('department_name') is-invalid @enderror" placeholder="Enter class name" required>

                                    @error('department_name')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror

                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="status">Status<span class="text-red">*</span></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1" {{ $data->status == 1 ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ $data->status == 0 ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <button title="Update" type="submit" class="btn btn-success mr-2">Update</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection



