@extends('dashboard.master')
@section('title', 'Donation Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Donation Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('donation.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th width="30%">Receipt No </th>
                                <td width="70%">{{ str_pad($data->receipt_no ?? '-', 2, '0', STR_PAD_LEFT) }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Date</th>
                                <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Fund Name</th>
                                <td width="70%">{{ $data->funds->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Donar Name</th>
                                <td width="70%">{{ $data->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Donar Phone</th>
                                <td width="70%">{{ $data->phone ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Amount</th>
                                <td width="70%">{{ $data->amount ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Taked By</th>
                                <td width="70%">{{ $data->users->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Purpose</th>
                                <td width="70%">{{ $data->purpose ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Address</th>
                                <td width="70%">{{ $data->address ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Note</th>
                                <td width="70%">{{ $data->note ?? '-' }}</td>
                            </tr>
                        </thead>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection
