@extends('dashboard.master')
@section('title', 'Create Hostel Fee Assign')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

<style>
    .ui-datepicker-calendar {
        display: none;
    }
    #student_id {
        text-align: center;
    }
</style>
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Create Hostel Fee Assign</b></span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('hostel.fees.assign.month') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="session_id">Session <span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control @error('session_id') is-invalid @enderror" required>
                                        <option value="">Select One</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('session_id')
                                        <span class="text-danger"><p>{{ $message }}</p></span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="class_id">Class <span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control @error('class_id') is-invalid @enderror" required>
                                        <option value="">Select One</option>
                                        @foreach ($class as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('class_id')
                                        <span class="text-danger"><p>{{ $message }}</p></span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="month">Set For <span class="text-red">*</span></label>
                                    <input type="number" name="month_for" id="month" class="form-control" value="{{ old('month') }}" required>
                                    <input type="hidden" name="type" value="2">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="from_month">Select Month <span class="text-red">*</span></label>
                                    @if($lastAssignedMonth)
                                        <input type="text" name="from_month" id="from_month" class="form-control"
                                        value="{{ \Carbon\Carbon::parse($lastAssignedMonth)->addMonth()->format('F-Y') }}"
                                        autocomplete="off" required>
                                    @else
                                        <input type="text" name="from_month" id="from_month" class="form-control" value="{{ now()->format('F-Y') }}" autocomplete="off" required>
                                    @endif
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-bordered">
                                    <tr>
                                        <th>Title</th>
                                        <th>Select Item</th>
                                        <th>Action</th>
                                    </tr>
                                    <tbody>
                                        @foreach ($fees as $fee)
                                        <tr>
                                            <td>
                                                <input name="fee_name[]" value="{{ $fee->id }}" class="fee-checkbox" data-fee-name="{{ $fee->name }}" title="select" type="checkbox" style="margin-right: 10px; height: 20px; width: 20px;">
                                                {{ $fee->name }}
                                            </td>
                                            <td class="selected-item"></td>
                                            <td>
                                                <button type="button" class="unselect-button" style="display: none; border: none; background: none; cursor: pointer;">
                                                    <i title="remove" class="fas fa-times" style="color: red;"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

<script>
$(document).ready(function() {
    // Month Picker (User can select any month)
    $(function() {
    $('#from_month').datepicker({
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        beforeShow: function(input, inst) {
            $(input).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        },
        onClose: function(dateText, inst) {
            var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear, inst.selectedMonth, 1));
            var year = inst.selectedYear;
            $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst.selectedMonth, 1)));
        }
    });
});
    // Checkbox selection logic
    document.querySelectorAll('.fee-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const feeName = this.dataset.feeName;
            const selectedItemCell = this.closest('tr').querySelector('.selected-item');
            const unselectButton = this.closest('tr').querySelector('.unselect-button');

            if (this.checked) {
                selectedItemCell.textContent = feeName;
                unselectButton.style.display = 'inline';
            } else {
                selectedItemCell.textContent = '';
                unselectButton.style.display = 'none';
            }
        });
    });

    // Unselect button logic
    document.querySelectorAll('.unselect-button').forEach(button => {
        button.addEventListener('click', function() {
            const checkbox = this.closest('tr').querySelector('.fee-checkbox');
            checkbox.checked = false;
            checkbox.dispatchEvent(new Event('change'));
        });
    });
});

@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif

</script>
@endpush
@endsection
