@extends('dashboard.master')
@section('title', 'Create Onabashik Fee Assign ')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Hostel Fee Assign</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('onabashik.fees.assign.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="session">Session<span class="text-red">*</span></label>
                                    <input type="text" class="form-control" value="{{ $session->name }}" readonly>
                                    <input type="hidden" name="session_id" class="form-control" value="{{ $session->id }}">
                                    <input type="hidden" name="type" value="2">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="class_id">Class<span class="text-red">*</span></label>
                                    <input type="text" class="form-control" value="{{ $class->name }}" readonly>
                                    <input type="hidden" name="class_id" class="form-control" value="{{ $class->id }}">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Month</th>
                                            <th>Name</th>
                                            <th class="text-center">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $startMonth = \Carbon\Carbon::createFromFormat('Y-m', $data['from_month']);
                                        @endphp
                                        @for($i = 0; $i < $data['month_for']; $i++)
                                            <tr>
                                                <td style="vertical-align: middle;">{{ $i + 1 }}</td>
                                                <td style="vertical-align: middle;">
                                                    {{ $startMonth->copy()->addMonthsNoOverflow($i)->format('F, Y') }}
                                                    <input type="hidden" name="month[]" value="{{ $startMonth->copy()->addMonthsNoOverflow($i)->format('Y-m') }}">
                                                </td>
                                                <td colspan="2">
                                                    <table class="table table-bordered">
                                                        <tbody>
                                                            @foreach ($fees as $fee)
                                                                <tr>
                                                                    <td class="text-left" style="width: 24.40%;">
                                                                        {{ $fee->name }}
                                                                        <input type="hidden" name="fee_id[{{ $i }}][]" value="{{ $fee->id }}">
                                                                    </td>
                                                                    <td class="text-center" style="width: 30%;">
                                                                        <input type="number" class="form-control text-center" value="{{ old('amount') }}" step="any" min="0" name="amount[{{ $i }}][]" placeholder="Amount" required>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        @endfor
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                    </form>

				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
