@extends('dashboard.master')
@section('title', 'Other Fees Assign')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>

    .ui-datepicker-calendar {
            display: none;
    }

    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
     .swal-title{
        font-size: 17px;
        color: red;
        padding: 0;
    }
    .swal-text{
        margin-top: 5px !important;
        color: black;
        background-color: white;
        box-shadow: none;
    }
    .swal-modal{
        max-width: 299px ;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Other Fees Assign</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Month</th>
                                <th>Class</th>
                                <th>Session</th>
                                <th>Fee</th>
                                <th>Amount</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Assign Other Fees')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="month">Month<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" name="month" id="month" value="{{ old('month') }}" class="form-control datepicker @error('month') is-invalid @enderror" placeholder="choose month" required>
                            <input type="hidden" value="3" id="type">
                            @error('month')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="session_id">Session<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="session_id" id="session_id" class="form-control @error('session_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($sessions as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                            @error('session_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="class_id">Class<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="class_id" id="class_id" class="form-control @error('class_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($class as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                            @error('class_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="fee_id">Fee <span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="fee_id" id="fee_id" class="form-control @error('fee_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($fees as $fee)
                                    <option value="{{ $fee->id }}">{{ $fee->name }}</option>
                                @endforeach
                            </select>
                            @error('fee_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="amount">Amount<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="number" name="amount" id="amount" class="form-control" value="{{ old('amount') }}" required>
                        </div>
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Create')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Assign Other Fees')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="" id="editId">

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="month">Month<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" name="month" id="monthEdit" value="{{ old('month') }}" class="form-control datepicker @error('month') is-invalid @enderror" placeholder="choose month" required>
                            <input type="hidden" value="3" id="type">
                            @error('month')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="session_id">Session<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="session_id" id="session_idEdit" class="form-control @error('session_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($sessions as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                            @error('session_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="class_id">Class<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="class_id" id="class_idEdit" class="form-control @error('class_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($class as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                            @error('class_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="fee_id">Fee <span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <select name="fee_id" id="fee_idEdit" class="form-control @error('fee_id') is-invalid @enderror" required>
                                <option value="">Select One</option>
                                @foreach ($fees as $fee)
                                    <option value="{{ $fee->id }}">{{ $fee->name }}</option>
                                @endforeach
                            </select>
                            @error('fee_id')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="amount">Amount<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="number" name="amount" id="amountEdit" class="form-control" value="{{ old('amount') }}" required>
                        </div>
                    </div>


                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>
$(function() {
            $('#month').datepicker( {
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            yearRange:"-30:+100",
            dateFormat: 'MM-yy',
            onClose: function(dateText, inst) {
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            }
            });
        });

$(function() {
            $('#monthEdit').datepicker( {
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            yearRange:"-30:+100",
            dateFormat: 'MM-yy',
            onClose: function(dateText, inst) {
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            }
            });
        });
    // add menu
    $(document).ready(function($){
             $('#save').on('click',function (event) {
                event.preventDefault();
                var url = "{{ route('other.fees.assign.store') }}";
                var month = $('#month').val();
                var amount = $('#amount').val();
                var class_id = $('#class_id').val();
                var fee_id = $('#fee_id').val();
                var type = $('#type').val();
                var session_id = $('#session_id').val();

                $.ajax({
                    url: url,
                    type: "get",
                    data: {
                        month : month,
                        amount : amount,
                        fee_id : fee_id,
                        class_id : class_id,
                        session_id : session_id,
                        type : type,
                    },
                    success: function(data) {
                        console.log("from store data", data);
                        if (data.success === true) {
                            location.reload();
                            toastr.success(data.message);
                            $('#add-class').trigger('clear');
                            $('#add-class')[0].reset();
                        }else{
                            location.reload();
                            toastr.error(data.message);
                            $('#add-class').trigger('clear');
                            $('#add-class')[0].reset();
                            $('#addClass').modal('show');
                        }
                    },

                });
                $.noConflict();
                $('#addClass').modal('hide');
            });
        });

        //edit menu
        $('#data_table').on('click', '#edit[href]', function (e) {
            e.preventDefault();
            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function(resp) {
                    $('#monthEdit').val(resp.month);
                    $('#amountEdit').val(resp.amount);
                    $('#class_idEdit').val(resp.class_id);
                    $('#fee_idEdit').val(resp.fee_id);
                    $('#session_idEdit').val(resp.session_id);
                    $('#editId').val(resp.id);
                }
            });
        });

        $('#update').on('click',function (event) {
                event.preventDefault();
                var id = $('#editId').val();
                var month = $('#monthEdit').val();
                var amount = $('#amountEdit').val();
                var class_id = $('#class_idEdit').val();
                var session_id = $('#session_idEdit').val();
                var fee_id = $('#fee_idEdit').val();

                var url = '{{ route("other.fees.assign.update",":id") }}';
console.log(url);
                $.ajax({
                url: url.replace(':id', id),
                'type':'GET',
                'data':{
                    month : month,
                    amount : amount,
                    fee_id : fee_id,
                    class_id : class_id,
                    session_id : session_id,
                },
                success:function(data)
                {
                    console.log(data);
                    if (data.success === true) {
                        toastr.success(data.message);
                        $('#data_table').DataTable().ajax.reload();
                        $('#editClass').modal('hide');
                    }else{
                        toastr.error(data.message);
                        $('#editClass').modal('show');
                    }
                }
            });

            });

    $(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('other.fees.assign')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'month', name: 'month'},
            {data: 'class', name: 'class'},
            {data: 'session', name: 'session'},
            {data: 'fee', name: 'fee'},
            {data: 'amount', name: 'amount'},
            {data: 'action', searchable: false, orderable: false}
        ],
        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
        buttons: [
            {
                extend: 'copy',
                className: 'btn-sm btn-info',
                title: 'Other Fees Assign List',
                header: true,
                footer: true,
            },
          
            {
                extend: 'print',
                className: 'btn-sm btn-danger',
                title: 'Other Fees Assign List',
                pageSize: 'A2',
                header: true,
                footer: true,
                orientation: 'landscape',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'colvis',
                className: 'btn-sm btn-warning',
                text: 'Column Visibility',
                title: 'Column Visibility',
                columns: ':not(:first-child)'
            }
        ],
        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection




