<!doctype html>
<html lang="bn">

<head>
    <meta charset="utf-8">
    <title>প্রাপ্তি ও প্রদান হিসাব</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bengali font -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700;800&display=swap"
        rel="stylesheet">
    <style>
        :root {
            --ink: #000;
            --border: #000;
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: "Noto Sans Bengali", system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
            color: var(--ink);
            background: #f5f5f5;
        }

        .sheet {
            width: 210mm;
            min-height: 297mm;
            margin: 10mm auto;
            background: #fff;
            padding: 12mm 12mm 14mm;
            box-shadow: 0 0 .6rem rgba(0, 0, 0, .08);
        }

        .title {
            font-weight: 800;
            font-size: 26px;
            margin: 0;
            letter-spacing: .3px;
        }

        .subline {
            margin: 0;
            font-size: 14px;
        }

        .grid-head {
            display: grid;
            grid-template-columns: 1fr 150px 1fr 150px;
            gap: 10px;
            margin-bottom: 10px;
        }

        .grid-head>div {
            border: 2px solid var(--border);
            text-align: center;
            font-weight: 700;
            padding: 6px 8px;
        }

        .twocol {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10%;
        }

        .blk {
            border: 2px solid var(--border);
            padding: 10px 12px;
        }

        .blk h5 {
            margin: 0 0 6px;
            font-size: 16px;
            font-weight: 700;
            text-align: center;
        }

        .amt {
            text-align: right;
        }

        .list-row {
            display: grid;
            /* grid-template-columns: 1fr 150px; */
            /* gap: 8px; */
            align-items: center;
            font-size: 14.5px;
            /* padding: 3px 0; */
        }

        .list-row.sub {
            font-size: 13.5px;
            opacity: .9;
        }

        .list-row.sub .label {
            padding-left: 16px;
            position: relative;
        }

        .list-row.sub .label:before {
            content: "–";
            position: absolute;
            left: 4px;
        }

        .bar-strong {
            padding-top: 8px;
            font-weight: 800;
            display: flex;
            justify-content: space-between;
            gap: 10%;
        }

        .toolbar {
            display: flex;
            justify-content: flex-end;
            gap: 8px;
            margin-bottom: 10px;
        }

        @media print {
            body {
                background: #fff;
            }

            .sheet {
                box-shadow: none;
                margin: 0;
                width: auto;
                min-height: auto;
                padding: 10mm;
                border: 2px solid black;
                margin: 10mm
            }

            .toolbar {
                display: none !important;
            }

            @page {
                size: A4 portrait;
                margin: 10mm;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }
        }
    </style>
</head>

<body>

    @php
        if (!function_exists('engToBanglaDate')) {
            function engToBanglaDate($date)
            {
                $months = [
                    'January' => 'জানুয়ারি',
                    'February' => 'ফেব্রুয়ারি',
                    'March' => 'মার্চ',
                    'April' => 'এপ্রিল',
                    'May' => 'মে',
                    'June' => 'জুন',
                    'July' => 'জুলাই',
                    'August' => 'আগস্ট',
                    'September' => 'সেপ্টেম্বর',
                    'October' => 'অক্টোবর',
                    'November' => 'নভেম্বর',
                    'December' => 'ডিসেম্বর',
                ];
                $eng = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
                $bng = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
                $c = \Carbon\Carbon::parse($date);
                $m = $months[$c->format('F')] ?? $c->format('F');
                $d = str_replace($eng, $bng, $c->format('j'));
                $y = str_replace($eng, $bng, $c->format('Y'));
                return "{$d} {$m} {$y}";
            }
        }
        if (!function_exists('engToBangla')) {
            function engToBangla($number)
            {
                $number = round($number, 2);
                $parts = explode('.', sprintf('%.2f', $number));
                $int = $parts[0];
                $dec = $parts[1];
                $last3 = substr($int, -3);
                $rest = substr($int, 0, -3);
                $fmt = $rest ? preg_replace('/\B(?=(\d{2})+(?!\d))/', ',', $rest) . ',' . $last3 : $last3;
                $fmt = $fmt . '.' . $dec;
                $eng = ['0', '1', '2', '3', '4', '5', '৬', '7', '8', '9']; // deliberate typo fix below
                $eng = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
                $bng = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
                return str_replace($eng, $bng, $fmt);
            }
        }

        $typeMap = [
            1 => 'ফান্ড গ্রহণ',
            2 => 'ফান্ড ব্যয়',
            3 => 'ওপেনিং',
            4 => 'সনদ',
            5 => 'দান',
            6 => 'শিক্ষার্থী ফি',
            7 => 'বোর্ডিং ফি',
            8 => 'মাহফিল দান প্রদান',
            9 => 'বাকি প্রদান',
            10 => 'বাকি গ্রহণ',
            11 => 'লোন প্রদান',
            12 => 'লোন গ্রহণ',
            13 => 'শিক্ষক বেতন',
            14 => 'ভর্তি ফি',
            15 => 'মাহফিল দান গ্রহণ',
            16 => 'স্পন্সর শিক্ষার্থী ফি',
            17 => 'শিক্ষক বোনাস',
            18 => 'ফান্ড ট্র্যান্সফার',
        ];

        $type =
            $fundType == '1' ? 'সাধারণ' : ($fundType == '2' ? 'গোরাবা' : ($fundType == '3' ? 'মাহফিল' : 'অন্যান্য'));
    @endphp

    <div class="sheet">
        <!-- toolbar (screen only) -->
        <div class="toolbar">
            <button class="btn btn-sm btn-dark" onclick="history.back()"><i class="bi bi-arrow-left"></i> Back</button>
            <button class="btn btn-sm btn-primary" onclick="window.print()"><i class="bi bi-printer"></i> Print</button>
        </div>

        <!-- Header -->
        <div class="text-center">
            <h1 class="title">প্রাপ্তি ও প্রদান হিসাব ({{ $type ?? 'N/A' }} তহবিল)</h1>
            {{-- <p class="subline">০১ রমজান ১৪৪৪ হি হতে ৩০ শাবান ১৪৪৫ হি পর্যন্ত।</p> --}}
            <p class="subline">{{ engToBanglaDate($start_date) }} ইং হতে {{ engToBanglaDate($end_date) }} ইং পর্যন্ত।
            </p>
        </div>

        <!-- Head columns -->
        <div class="grid-head">
            <div>প্রাপ্তি</div>
            <div>টাকা</div>
            <div>পরিশোধ</div>
            <div>টাকা</div>
        </div>

        <!-- Two main columns -->
        <div class="twocol">
            <!-- Left: Receipts -->
            <div>
                <div class="row">
                    <div class="mb-1"><b>প্রাপ্ত তথ্যের উৎস</b></div>
                    <div style="display:flex; justify-content:space-between">
                        <div>পুর্বের টাকা</div>
                        <div class="amt">{{ engToBangla($previous_balance ?? 0) }}</div>
                    </div>

                    <div style="display:flex; justify-content:space-between; margin-top:20px">
                        <b>প্রাপ্তির বিবরণ</b>
                        <p class="mb-0">{{ engToBangla($periodIncome) }}</p>
                    </div>

                    {{-- নামের কলাম --}}
                    <div class="col-md-6" style="padding:8px 10px">
                        @foreach ($incomeDetails ?? [] as $typeKey => $amt)
                            <div class="list-row">
                                <div>{{ $typeMap[$typeKey] ?? 'টাইপ ' . $typeKey }}</div>
                                <div class="amt d-md-none">{{ engToBangla($amt) }}</div> {{-- small screens fallback --}}
                            </div>

                            {{-- Optional subtypes (fee_id) --}}
                            @if (!empty($incomeTree[$typeKey]['subtypes'] ?? []))
                                @foreach ($incomeTree[$typeKey]['subtypes'] as $sub)
                                    <div class="list-row sub">
                                        <div class="label">{{ $sub['name'] ?? 'Fee #' . $sub['fee_id'] }}</div>
                                        <div class="amt d-md-none">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                                    </div>
                                @endforeach
                            @endif
                        @endforeach
                    </div>

                    {{-- Amounts কলাম --}}
                    <div class="col-md-6" style="border:2px solid var(--border); padding:8px 10px">
                        @foreach ($incomeDetails ?? [] as $typeKey => $amt)
                            <div class="list-row">
                                <div></div>
                                <div class="amt">{{ engToBangla($amt) }}</div>
                            </div>

                            {{-- Optional subtype amounts --}}
                            @if (!empty($incomeTree[$typeKey]['subtypes'] ?? []))
                                @foreach ($incomeTree[$typeKey]['subtypes'] as $sub)
                                    <div class="list-row sub">
                                        <div></div>
                                        <div class="amt">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                                    </div>
                                @endforeach
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Right: Payments -->
            <div>
                <div class="row">
                    <div style="display:flex; justify-content:space-between; margin-top:20%">
                        <b>প্রদানের বিবরণ</b>
                        <p class="mb-0">{{ engToBangla($periodExpense) }}</p>
                    </div>

                    {{-- নামের কলাম --}}
                    <div class="col-md-6" style="padding:8px 10px">
                        @foreach ($expenseDetails ?? [] as $typeKey => $amt)
                            <div class="list-row">
                                <div>{{ $typeMap[$typeKey] ?? 'টাইপ ' . $typeKey }}</div>
                                <div class="amt d-md-none">{{ engToBangla($amt) }}</div>
                            </div>

                            {{-- Optional subtypes --}}
                            @if (!empty($expenseTree[$typeKey]['subtypes'] ?? []))
                                @foreach ($expenseTree[$typeKey]['subtypes'] as $sub)
                                    <div class="list-row sub">
                                        <div class="label">{{ $sub['name'] ?? 'Fee #' . $sub['fee_id'] }}</div>
                                        <div class="amt d-md-none">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                                    </div>
                                @endforeach
                            @endif
                        @endforeach
                    </div>

                    {{-- Amounts কলাম --}}
                    <div class="col-md-6" style="border:2px solid var(--border); padding:8px 10px">
                        @foreach ($expenseDetails ?? [] as $typeKey => $amt)
                            <div class="list-row">
                                <div></div>
                                <div class="amt">{{ engToBangla($amt) }}</div>
                            </div>

                            {{-- Optional subtype amounts --}}
                            @if (!empty($expenseTree[$typeKey]['subtypes'] ?? []))
                                @foreach ($expenseTree[$typeKey]['subtypes'] as $sub)
                                    <div class="list-row sub">
                                        <div></div>
                                        <div class="amt">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                                    </div>
                                @endforeach
                            @endif
                        @endforeach
                    </div>

                    <div style="text-align:right; margin-top:30px; display:flex; justify-content:space-between">
                        <p>নগদ তহবিল</p>
                        <p style="border:2px solid var(--border); padding:8px 10px">
                            {{ engToBangla($current_balance ?? 0) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom grand bars -->
        <div class="row g-3 mt-2">
            <div class="col-md-6">
                <div class="bar-strong">
                    <span style="border-top:2px solid var(--border); border-bottom:2px solid var(--border);">
                        {{ engToBangla($incomeWithPreviousBalance ?? 0) }}
                    </span>
                </div>
            </div>
            <div class="col-md-6">
                <div class="bar-strong">
                    <span style="border-top:2px solid var(--border); border-bottom:2px solid var(--border);">
                        {{ engToBangla($expenseWithCurrentBalance ?? 0) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
</body>

</html>
