@extends('dashboard.master')
@section('title', 'Fund Collect Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Fund Collect Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('fund.collect.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            @if(!empty($data->receipt_no))
                            <tr>
                                <th width="30%">Receipt No</th>
                                <td width="70%">{{ str_pad($data->receipt_no ?? '-', 2, '0', STR_PAD_LEFT) }}</td>
                            </tr>
                            @endif
                            @if(!empty($data->invoice_no))
                            <tr>
                                <th width="30%">Invoice No</th>
                                <td width="70%">{{ str_pad($data->invoice_no ?? '-', 2, '0', STR_PAD_LEFT) }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->date))
                                <tr>
                                    <th width="30%">Date</th>
                                    <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->funds))
                                <tr>
                                    <th width="30%">Fund Name</th>
                                    <td width="70%">{{ $data->funds->name ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->students))
                                <tr>
                                    <th width="30%">Student</th>
                                    <td width="70%">{{ $data->students->name ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->donar_id) || (!empty($data->name) && !empty($data->phone)))
                                <tr>
                                    <th width="30%">Donar Name</th>
                                    @php
                                        $name = '';
                                        $phone = '';

                                        if (empty($data->donar_id)) {
                                            $name = $data->name ?? '';
                                            $phone = $data->phone ?? '';
                                        } else {
                                            $name = $data->donar->name ?? '';
                                            $phone = $data->donar->phone ?? '';
                                        }
                                    @endphp
                                    <td width="70%">{{ $name ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty($phone))
                                <tr>
                                    <th width="30%">Donar Phone</th>
                                    <td width="70%">{{ $phone ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->amount))
                                <tr>
                                    <th width="30%">Amount</th>
                                    <td width="70%">{{ $data->amount ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty(Auth::user()->name))
                                <tr>
                                    <th width="30%">Taked By</th>
                                    <td width="70%">{{ Auth::user()->name ?? '' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->purpose))
                                <tr>
                                    <th width="30%">Purpose</th>
                                    <td width="70%">{{ $data->purpose ?? '-' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->address))
                                <tr>
                                    <th width="30%">Address</th>
                                    <td width="70%">{{ $data->address ?? '-' }}</td>
                                </tr>
                            @endif

                            @if(!empty($data->note))
                                <tr>
                                    <th width="30%">Note</th>
                                    <td width="70%">{{ $data->note ?? '-' }}</td>
                                </tr>
                            @endif
                        </thead>
                    </table>

				</div>
			</div>
		</div>
	</section>
</div>

@endsection
