@extends('dashboard.master')
@section('title', 'Fund Expense Edit')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Fund Expense Edit</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('fund.expense.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Receipt No<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no" value="{{ $data->receipt_no }}" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Invoice No</label>
                                    <input type="text" name="invoice_no" id="invoice_no" value="{{ $data->invoice_no }}" class="form-control" >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ $data->date ?? '' }}" class="form-control" placeholder="date" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Expense Type<span class="text-red">*</span></label>
                                    <select name="expense_type_id" id="expense_type_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($types as $type)
                                        <option value="{{ $type->id }}" @if($data->expense_type_id == $type->id) selected @endif>{{ $type->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}" @if($data->fund_id == $fund->id) selected @endif>{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Expense By<span class="text-red">*</span></label>
                                    <input type="text" name="name" value="{{ $data->name ?? '' }}" id="name" class="form-control" placeholder="name">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="">Amount<span class="text-red">*</span> (Available: <b id="availableAmount"></b>)</label>
                                    <input type="number" name="amount" id="amount" value="{{ $data->amount ?? '' }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="image">Cash Memo</label>
                                    <input type="file" class="form-control" name="cash_memo" id="cash_memo">
                                    <input type="hidden" name="current_image" value="{{ $data->cash_memo }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Purpose<span class="text-red">*</span></label>
                                    <textarea name="purpose" id="purpose" cols="2" rows="2" class="form-control" required>{{ $data->purpose ?? '' }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ $data->note ?? '' }}</textarea>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd',
        onSelect: function (dateText) {
            alert("Data will be updated to this date: " + dateText);
        }
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });
});

$(document).ready(function() {
    let availableAmount = 0;

    function updateAvailableBalance(fund_id) {
        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    }

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();
        updateAvailableBalance(fund_id);
        $('#amount').val(' ');
    });

    var preSelectedFundId = $('#fund_id').val();
    if (preSelectedFundId) {
        updateAvailableBalance(preSelectedFundId);
    }

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });

    $('#date').datepicker({
        dateFormat: 'yy-mm-dd'
    });
});

</script>
@endpush
@endsection

