@extends('dashboard.master')
@section('title', 'Fund Expense Details')
@section('content')
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>

    <style>
        .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            padding: 20px;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            .printArea,
            .printArea * {
                visibility: visible;
            }

            .printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Fund Expense Details</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('fund.expense.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                        <a title="Print" id="printButton" type="button" class="btn btn-sm btn-danger">
                            <i class="fas fa-file mr-1"></i>
                            Print
                        </a>

                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body printArea">
                        <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                            style="width:100%; height:150px; margin-bottom:20px;">
                        <table class="table table-bordered table-striped table-hover print-table">
                            <tbody>

                                @if (!empty($data->receipt_no))
                                    <tr>
                                        <th width="30%">Receipt No</th>
                                        <td width="70%">{{ $data->receipt_no }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->invoice_no))
                                    <tr>
                                        <th>Invoice No</th>
                                        <td>{{ $data->invoice_no }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->date))
                                    <tr>
                                        <th>Date</th>
                                        <td>{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->funds->name))
                                    <tr>
                                        <th>Fund Name</th>
                                        <td>{{ $data->funds->name }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->name))
                                    <tr>
                                        <th>Expense By</th>
                                        <td>{{ $data->name }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->amount))
                                    <tr>
                                        <th>Amount</th>
                                        <td>{{ number_format($data->amount, 2) }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->extypes->name))
                                    <tr>
                                        <th>Expense Type</th>
                                        <td>{{ $data->extypes->name }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->purpose))
                                    <tr>
                                        <th>Purpose</th>
                                        <td>{{ $data->purpose }}</td>
                                    </tr>
                                @endif

                                @if (!empty($data->cash_memo))
                                    <tr>
                                        <th>Cash Memo</th>
                                        <td>
                                            <a href="{{ route('fund.expense.cashmemo.download', $data->id) }}" download>
                                                <img src="{{ asset('/backend/expense/' . $data->cash_memo) }}"
                                                    alt="Cash Memo" style="max-height: 100px;">
                                            </a>
                                        </td>
                                    </tr>
                                @endif

                                @if (!empty($data->note))
                                    <tr>
                                        <th>Note</th>
                                        <td>{{ $data->note }}</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        <div id="footer-img">
                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                                style="width:100%; height:150px; margin-top:20px;">
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script>
            $('#printButton').on('click', function() {
                window.print();
            });
        </script>
    @endpush
@endsection
