@extends('dashboard.master')
@section('title', 'General Fund List')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            #printArea,
            #printArea * {
                visibility: visible;
            }

            #printArea {
                position: relative;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .table-container {
                margin-top: 20px;
                margin-bottom: 20px;
            }

            table {
                width: 100% !important;
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .dataTables_length,
            .dataTables_filter,
            .dataTables_paginate,
            .dataTables_info,
            .print,
            .hideClass,
            .dt-buttons {
                display: none !important;
            }

            th.action,
            td.action {
                display: none !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }

            @page {
                size: A4 portrait;
                margin: 10mm;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }

            tr {
                page-break-inside: avoid;
            }

            .print-only img {
                width: 100% !important;
                max-width: 100% !important;
            }
        }

        /* Summary bar styles */
        .summary-bar .card {
            border: 1px solid #e9ecef;
        }

        .summary-metric .value {
            font-weight: 700;
            font-size: 1.1rem;
        }

        .summary-metric .label {
            color: #6c757d;
            font-size: .85rem;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                        <span><b>General Fund List</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                        <a title="Create" href="{{ route('fund.collect.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i> Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                {{-- Filters row --}}
                <div class="card mb-2">
                    <div class="card-body d-flex flex-wrap gap-3 align-items-end">
                        <div>
                            <label for="filter_fund_id" class="mb-1"><b>Fund</b></label>
                            <select id="filter_fund_id" class="form-control" style="min-width:240px">
                                <option value="">All General Funds</option>
                                @foreach ($funds as $f)
                                    <option value="{{ $f->id }}">{{ $f->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="filter_type" class="mb-1"><b>Type</b></label>
                            <select id="filter_type" class="form-control" style="min-width:180px">
                                <option value="">All Types</option>
                                <option value="1">Income</option>
                                <option value="2">Expense</option>
                                {{-- Opening removed --}}
                            </select>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="button" id="apply_filters" class="btn btn-primary">Apply</button>
                            <button type="button" id="reset_filters" class="btn btn-outline-secondary">Reset</button>
                        </div>
                    </div>
                </div>

                {{-- Summary bar (Opening removed) --}}
                <div class="summary-bar mb-2" id="summaryBar" style="display:none;">
                    <div class="row g-2">
                        <div class="col-sm-4">
                            <div class="card p-3 summary-metric">
                                <div class="label">Income</div>
                                <div class="value text-success" id="sum_income">0.00</div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card p-3 summary-metric">
                                <div class="label">Expense</div>
                                <div class="value text-danger" id="sum_expense">0.00</div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card p-3 summary-metric">
                                <div class="label" id="balance_label">Current Balance</div>
                                <div class="value" id="sum_balance">0.00</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card" id="printArea">
                    <div class="card-body">

                        <table id="data_table"
                            class="table table-bordered table-striped data-table table-hover print-table">
                            <thead>
                                <tr class="print-only">
                                    <td colspan="8" style="padding:0;">
                                        <img src="{{ asset('img/' . $invoice->invoice_header) }}" style="width:100%;">
                                    </td>
                                </tr>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Fund</th>
                                    <th>Donar</th>
                                    <th>Type</th>
                                    <th>Purpose</th>
                                    <th>Amount</th>
                                    <th class="action hideClass">Action</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                            <tfoot>
                                <tr class="print-only">
                                    <td colspan="8" style="padding:0%;">
                                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" style="width:100%;">
                                    </td>
                                </tr>
                            </tfoot>
                        </table>

                        <button class="btn btn-danger float-left mt-5 print" id="print">Print</button>
                    </div>
                </div>

            </div>
        </section>
    </div>

@endsection

@push('js')
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" crossorigin="anonymous"
        referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(function() {
            var dTable = $('#data_table').DataTable({
                order: [],
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    [10, 25, 50, 100, "All"]
                ],
                processing: true,
                responsive: false,
                serverSide: true,
                scrollX: true,
                autoWidth: false,
                scroller: {
                    loadingIndicator: false
                },
                language: {
                    processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                },
                pagingType: "full_numbers",
                ajax: {
                    url: "{{ route('general.fund') }}",
                    type: "get",
                    data: function(d) {
                        d.fund_id = $('#filter_fund_id').val() || '';
                        d.payment_type = $('#filter_type').val() || '';
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: true,
                        orderable: true
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'fund',
                        name: 'fund'
                    },
                    {
                        data: 'donar',
                        name: 'donar'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'purpose',
                        name: 'purpose'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'action',
                        searchable: false,
                        orderable: false,
                        className: 'hideClass'
                    }
                ],
                dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center print'B><'col-sm-3'f>>tipr",
                buttons: [{
                        extend: 'copy',
                        className: 'btn-sm btn-info',
                        title: 'General Fund List',
                        header: true,
                        footer: true
                    },
                    {
                        extend: 'excel',
                        className: 'btn-sm btn-success',
                        title: 'General Fund List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6],
                            stripHtml: true
                        }
                    },
                    {
                        extend: 'print',
                        className: 'btn-sm btn-danger',
                        title: 'General Fund List',
                        pageSize: 'A2',
                        header: true,
                        footer: true,
                        orientation: 'landscape',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'colvis',
                        className: 'btn-sm btn-warning',
                        text: 'Column Visibility',
                        title: 'Column Visibility',
                        columns: ':not(:first-child)'
                    }
                ],
            });

            // Summary renderer after every AJAX
            $('#data_table').on('xhr.dt', function(e, settings, json) {
                const box = $('#summaryBar');
                if (json && json.summary) {
                    const s = json.summary;
                    const fmt = n => Number(n || 0).toLocaleString(undefined, {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    });
                    $('#sum_income').text(fmt(s.income));
                    $('#sum_expense').text(fmt(s.expense));
                    $('#sum_balance').text(fmt(s.balance));
                    box.show();
                } else {
                    box.hide();
                }
            });

            // Filters
            $('#apply_filters').on('click', function() {
                dTable.ajax.reload();
            });
            $('#reset_filters').on('click', function() {
                $('#filter_fund_id').val('');
                $('#filter_type').val('');
                dTable.ajax.reload();
            });

            // Delete (unchanged)
            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();
                $.ajaxSetup({
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                    }
                });
                const url = $(this).data('remote');
                swal({
                        title: `Are you sure?`,
                        text: "Want to delete this record?",
                        buttons: true,
                        dangerMode: true
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                url: url,
                                type: 'get',
                                dataType: 'json',
                                data: {
                                    submit: true,
                                    _method: 'delete',
                                    _token: "{{ csrf_token() }}"
                                }
                            }).always(function(data) {
                                $('#data_table').DataTable().ajax.reload();
                                if (data.success === true) {
                                    toastr.success(data.message);
                                } else {
                                    toastr.error(data.message);
                                }
                            });
                        }
                    });
            });

            // Print (unchanged)
            $('.print-only').hide();
            $('#print').on('click', function() {
                $('th.action, td.action').hide();
                $('.print-only').show();
                $('.hideClass').show();
                window.print();
                setTimeout(function() {
                    $('.print-only').hide();
                    $('th.action, td.action').show();
                }, 500);
            });

            // Toastr flashes
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 1000
                };
                toastr.success("{{ session('success') }}");
            @endif
            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        });
    </script>
@endpush
