<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <title>সনদপত্র</title>
     <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Siyam Rupali', 'SolaimanLipi', sans-serif;
            background: #fefae0;
        }

        .certificate {
            width: 100%;
            max-width: 100%;
            height: auto;
            padding: 30px;
            background-image: url('{{ asset($invoiceBgPath) }}') !important;
            background-size: cover !important;
            background-position: center !important;
            background-repeat: no-repeat !important;
            border: 15px solid transparent;
            /* border-image: url('https://i.ibb.co/X8fZjSx/golden-border.png') 50 round; */
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            box-sizing: border-box;
        }

        .inner {
            border: 3px double #d4af37;
            padding: 25px;
            background: transparent;
            /* background: rgba(255, 255, 255, 0.96); */

        }

        .bismillah {
            text-align: center;
            font-size: 18px;
            font-style: italic;
            margin-bottom: 10px;
        }

        .heading {
            text-align: center;
            color: #3b2f0d;
        }

        .heading h1 {
            font-size: 20px;
            margin: 0;
        }

        .heading h2 {
            font-size: 16px;
            margin: 5px 0 15px;
        }

        .logo {
            text-align: center;
            margin-bottom: 15px;
        }

        .logo img {
            height: 60px;
        }

        .banner {
            display: inline-block;
            background: linear-gradient(to right, #d4af37, #f5deb3, #d4af37);
            padding: 10px 30px;
            border-radius: 50px;
            font-size: 20px;
            font-weight: bold;
            color: #4b3300;
            text-align: center;
            margin: 15px auto;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
        }

        .sub-banner {
            display: inline-block;
            background: #efe2b2;
            padding: 8px 25px;
            border-radius: 30px;
            font-size: 16px;
            font-weight: bold;
            color: #4b3300;
            margin-bottom: 25px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .title,
        .subtitle {
            text-align: center;
        }

        .content p {
            font-size: 16px;
            margin: 10px 0;
            line-height: 1.6;
            text-align: justify;
        }

        .highlight {
            font-weight: bold;
            color: #000;
        }

        .footer {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
        }

        .footer div {
            width: 45%;
            text-align: center;
            font-size: 14px;
        }

        .issued {
            text-align: right;
            font-size: 13px;
            margin-top: 25px;
            color: #666;
        }

        @media print {
            @page {
                size: A4 landscape;
                margin: 10mm;
            }

            body {
                background: none !important;
                padding: 0;
                margin: 0;
            }

            .certificate {
                box-shadow: none;
                border: none;
                background-size: 100% 100%;
            }
        }
    </style>
</head>

<body>

    <div class="certificate">
        <div class="inner">
            <div class="bismillah">بِسْمِ اللَّهِ الرَّحْمَنِ الرَّحِيم</div>

            <div class="heading">
                <h1>{{ $setting->long_name ?? '' }}</h1>
                <h2>{{ $setting->address ?? '' }}</h2>
            </div>

            <div class="logo">
                <img src="{{ asset('img/' . $setting->logo) }}" alt="Logo">
            </div>

            <div class="title">
                <div class="banner">সনদপত্র</div>
            </div>

            <div class="subtitle">
                <div class="sub-banner">প্রশিক্ষণমূলক মূল্যায়ন পরীক্ষার ({{ $data->students->stuclass->name ?? '' }}) -
                    {{ $data->students->stusession->name ?? '' }} ইং</div>
            </div>

            <div class="content">
                <p>শিক্ষার্থীর নাম: <span class="highlight">{{ $data->students->name ?? '' }}</span>
                    &nbsp;&nbsp;&nbsp;&nbsp; পরীক্ষার নাম: <span class="highlight">{{ $data->exam->name ?? '' }}</span>
                </p>
                <p>পিতার নাম: <span class="highlight">{{ $data->students->father_name ?? '' }}</span>
                    &nbsp;&nbsp;&nbsp;&nbsp; মাতার নাম: <span
                        class="highlight">{{ $data->students->mother_name ?? '' }}</span></p>
                <p>প্রতিষ্ঠানের নাম: <span class="highlight">{{ $setting->long_name ?? '' }}</span></p>
                <p>রোল নম্বর: <span class="highlight">{{ $data->students->roll_no }}</span> &nbsp;&nbsp;&nbsp;&nbsp;
                    শ্রেণি: <span class="highlight">{{ $data->students->stuclass->name ?? '' }}</span>
                    &nbsp;&nbsp;&nbsp;&nbsp; সাল: <span class="highlight">{{ $data->students->stusession->name ?? '' }}
                        ইং</span></p>
                <p>কার্য্য ফলাফল: <span class="highlight">{{ $avgGrade->name ?? '' }}</span> প্রাপ্ত হয়েছে।</p>
                <p>সনদ প্রদান তারিখ: <span class="highlight">
                        {{ \Carbon\Carbon::parse($setting->date)->format('d/m/Y') ?? '' }}</span></p>
            </div>

            <div class="footer">
                <div>
                    --------------------------- <br>
                    স্বাক্ষর (সার্টিফিকেট প্রদানকারী)
                </div>
                <div>
                    --------------------------- <br>
                    স্বাক্ষর (প্রধান শিক্ষক)
                </div>
            </div>

        </div>
    </div>

    <script type="text/javascript">
        localStorage.clear();

        function auto_print() {
            window.print()
        }
        setTimeout(auto_print, 1000);
    </script>
</body>

</html>
