@extends('dashboard.master')
@section('title', 'Sonad Details')
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Sonad Details</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="Create" href="{{ route('sonad.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            @if(!empty($data->receipt_no))
                            <tr>
                                <th width="30%">Receipt No</th>
                                <td width="70%">{{ $data->receipt_no }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->date))
                            <tr>
                                <th width="30%">Date</th>
                                <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->students->name))
                            <tr>
                                <th width="30%">Student Name</th>
                                <td width="70%">{{ $data->students->name }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->exam->name))
                            <tr>
                                <th width="30%">Exam Name</th>
                                <td width="70%">{{ $data->exam->name }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->students->stuclass->name))
                            <tr>
                                <th width="30%">Class Name</th>
                                <td width="70%">{{ $data->students->stuclass->name }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->students->register_no))
                            <tr>
                                <th width="30%">Reg No</th>
                                <td width="70%">{{ $data->students->register_no }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->funds->name))
                            <tr>
                                <th width="30%">Fund Name</th>
                                <td width="70%">{{ $data->funds->name }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->amount))
                            <tr>
                                <th width="30%">Amount</th>
                                <td width="70%">{{ $data->amount }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->users->name))
                            <tr>
                                <th width="30%">Given By</th>
                                <td width="70%">{{ $data->users->name }}</td>
                            </tr>
                            @endif

                            @if(!empty($data->note))
                            <tr>
                                <th width="30%">Note</th>
                                <td width="70%">{{ $data->note }}</td>
                            </tr>
                            @endif
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection
