@extends('dashboard.master')
@section('title', 'Balance Sheet')
@push('css')
<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Balance Sheet</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Create Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Date</th>
                                <th>Name</th>
                                <th>Credit(BDT)</th>
                                <th>Debit(BDT)</th>
                                <th>Current Balance(BDT)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tfoot >
                                <tr id="total_tr" style="display:none">
                                    <td class="tg-0lax" colspan="2"></td>
                                    <td class="tg-0lax" style="background: #f2f2f2">Total</td>
                                    <td class="tg-0lax" style="background: #f2f2f2"><b id="totalCredit"> </b></td>
                                    <td class="tg-0lax" style="background: #f2f2f2"><b id="totalDebit"> </b></td>
                                    <td class="tg-0lax" style="background: #f2f2f2"><b id="currentBalance"> </b></td>
                                </tr>
                            </tfoot>
                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script>

    $(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('general-balance-sheet')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false},
            {data: 'date', name: 'date'},
            {data: 'name', name: 'name'},
            {data: 'credit_amount', name: 'credit_amount'},
            {data: 'debit_amount', name: 'debit_amount'},
            {data: 'current_balance', name: 'current_balance'},
        ],
            initComplete: function(data) {
                var totalCredit = data.json.totalCredit;
                var totalDebit = data.json.totalDebit;
                var currentBalance = data.json.currentBalance;
                $('#total_tr').hide();
                if(totalCredit != ''){
                    $('#total_tr').show();
                }
                document.getElementById('totalCredit').innerHTML = totalCredit;
                document.getElementById('totalDebit').innerHTML = totalDebit;
                document.getElementById('currentBalance').innerHTML = currentBalance;
            },

        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                buttons: [
                        {
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Balance Sheet',
                            header: true,
                            footer: true,
                            exportOptions: {
                                columns: ['0,1,2,3,4'],
                            }
                        },
                       
                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Balance Sheet',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ['0,1,2,3,4'],
                                stripHtml: false
                            }
                        }
                    ],
        });
    });

</script>
@endpush
@endsection
