@extends('dashboard.master')
@section('title', 'Edit Guraba Fund')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
</style>
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Guraba Fund</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('guraba-fund.update', $data->id) }}" method="POST">
						@csrf
                        @method('PUT')
						<div class="row">
							<div class="col-sm-2">
								<div class="form-group">
									<label for="receipt_no">Receipt No<span class="text-red">*</span></label>
									<input type="text" name="receipt_no" id="receipt_no" value="{{ $data->receipt_no }}" class="form-control" placeholder="receipt no" readonly>

								</div>
							</div>
							<div class="col-sm-4">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>

									<input type="text" name="date" id="date" value="{{ $date }}" class="form-control" placeholder="Enter date" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
								<div class="form-group">
									<label for="name"><span class="bangla">নাম</span>/Name<span class="text-red">*</span></label>

									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-3">
								<div class="form-group">
									<label for="mobile"><span class="bangla">মোবাইল </span>/Mobile<span class="text-red">*</span></label>

									<input type="text" name="mobile" id="mobile" value="{{ $data->mobile }}" class="form-control @error('mobile') is-invalid @enderror" placeholder="মোবাইল লিখুন" required>

									@error('mobile')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span class="text-red">*</span></label>

									<input type="text" name="amount" id="amount" value="{{ $data->amount }}" class="form-control @error('amount') is-invalid @enderror" placeholder="পরিমাণ লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
								<div class="form-group">
									<label for="purpose"><span class="bangla">বাবদ</span>/On Account Of<span class="text-red">*</span></label>

									<textarea rows="1" name="purpose" id="purpose" class="form-control" placeholder="বাবদ লিখুন" required>{!! $data->purpose !!}</textarea>

									@error('purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-6">
								<div class="form-group">
									<label for="in_word"><span class="bangla">কথায়</span>/In Word </label>

                                    <textarea rows="2" name="in_word" id="in_word" class="form-control" placeholder="কথায় লিখুন">{!! $data->in_word !!}</textarea>

									@error('in_word')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>
							<div class="col-sm-6">
								<div class="form-group">
									<label for="address"><span class="bangla">ঠিকানা </span>/Address<span class="text-red">*</span></label>

                                    <textarea rows="2" name="address" id="address" class="form-control" placeholder="ঠিকানা  লিখুন" required>{!! $data->address !!}</textarea>

									@error('address')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="note"><span class="bangla">বিঃদ্রঃ</span>/Note</label>
									<textarea rows="2" name="note" id="note" class="form-control" placeholder="বিঃদ্রঃ লিখুন">{!! $data->note !!}</textarea>

								</div>
							</div>

						</div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

    <script>
       $(function () {
           $('#date').datepicker({
               dateFormat: 'dd MM yy'
           });
       });
       </script>
@endpush
@endsection
