<nav class="main-header navbar navbar-expand bg-navbar-custom">
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link menu-icon" data-widget="pushmenu" href="#" role="button">
                <i class="fas fa-bars d-sm-block d-md-none"></i>
            </a>
        </li>
    </ul>

    @php
        $site = DB::table('settings')->first();
    @endphp
    <h6 class="d-none d-lg-block navbar-title">
        <b>{{ $site->long_name ?? '' }}</b>
    </h6>

    <ul class="navbar-nav ml-auto">
        <div class="nav-link user-info">
            <span>{{ Auth::user()->name }} </span>
        </div>

        <li class="nav-item">
            <form method="POST" action="{{ route('logout') }}" class="nav-link logout-btn user-info">
                @csrf
                <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();">
                    <i class="fas fa-sign-out-alt"></i> লগ আউট
                </a>
            </form>
        </li>

        <li class="nav-item">
            <a class="nav-link fullscreen-icon" data-widget="fullscreen" href="#" role="button">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>
    </ul>
</nav>

<!-- CSS -->
<style>
span.brand-text.font-weight-light.bangla {
    color: #000000 !important;
}
i.fas.fa-arrow-circle-right {
    display: none;
}
.bg-navbar-custom {
    background: rgba(245, 245, 245, 0.8);
    backdrop-filter: blur(10px);
    border-radius: 10px;
    box-shadow: 3px 3px 10px rgba(0, 0, 0, 0.1), -3px -3px 10px rgba(255, 255, 255, 0.6);
    padding: 12px 20px;
}
.navbar-title,
.menu-icon i,
.logout-btn a,
.fullscreen-icon i {
    color: #000 !important;
}
.navbar-title {
    font-weight: bold;
    font-size: 25px;
    text-align: center;
    flex-grow: 1;
}
.menu-icon i {
    font-size: 20px;
    transition: 0.3s;
}
.menu-icon:hover i {
    transform: scale(1.1);
}
.user-info {
    font-weight: bold;
    font-size: 14px;
    background: rgba(255, 255, 255, 0.6);
    padding: 5px 12px;
    border-radius: 8px;
    box-shadow: inset 2px 2px 4px rgba(0, 0, 0, 0.1), inset -2px -2px 4px rgba(255, 255, 255, 0.5);
}
div.nav-link.user-info {
    color: #000000;
}
ul div span {
    color: #000000;
}
.logout-btn a {
    background: linear-gradient(145deg, #f5f5f5, #e0e0e0);
    padding: 6px 12px;
    border-radius: 8px;
    transition: 0.3s;
    display: flex;
    align-items: center;
    gap: 5px;
}
.logout-btn a:hover {
    background: linear-gradient(145deg, #e0e0e0, #c9c9c9);
    transform: translateY(-2px);
}
.fullscreen-icon i {
    font-size: 18px;
    transition: 0.3s;
}
.fullscreen-icon:hover i {
    transform: scale(1.1);
}

@media (max-width: 991px) {
    .user-info {
        font-size: 10px !important;
        display: inline-flex;
        align-items: center;
        justify-content: left;
    }
    .nav-item .logout-btn a {
        font-size: 10px !important;
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }
}
</style>
