@extends('dashboard.master')
@section('title', 'Mahfil Given Create')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Mahfil Given Create</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('mahfil.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Receipt No<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no" value="{{ $receipt_no }}" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ now()->format('d-m-Y') }}" class="form-control" placeholder="date" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Amount<span class="text-red">*</span> <span id="showAmount" style="display:none;">(Available: <b id="availableAmount"></b>)</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control" placeholder="amount">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Given To<span class="text-red">*</span></label>
                                    <input type="text" name="name" id="given" value="{{ old('given') }}" class="form-control" placeholder="given to">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Address</label>
                                    <textarea name="address" id="address" cols="2" rows="2" class="form-control">{{ old('address') }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ old('note') }}</textarea>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>


@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'dd-m-yy'
    });
});

$(document).ready(function() {
    let availableAmount = 0;

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();

        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    });

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });
});

</script>
@endpush
@endsection

