@extends('dashboard.master')
@section('title', 'হিসাব ও অর্থ বিভাগ')

@section('content')

    <style>
        .cool-card {
            background: linear-gradient(145deg, #ffffff, #f3f3f3);
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease-in-out;
            padding: 30px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
            border: 1px solid #eee;
            cursor: pointer;
        }

        .cool-card:hover {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            transform: translateY(-5px);
        }

        .cool-card a.full-link {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .cool-card h5 {
            font-weight: 600;
            font-size: 18px;
            color: #333;
            margin-top: 15px;
            position: relative;
            z-index: 2;
        }

        .cool-card img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ddd;
            padding: 5px;
            transition: all 0.3s ease-in-out;
            z-index: 2;
            position: relative;
        }

        .cool-card:hover img {
            transform: scale(1.1);
            border-color: #00a99d;
        }

        .cool-card::after {
            content: "";
            position: absolute;
            bottom: -30px;
            right: -30px;
            width: 80px;
            height: 80px;
            background: rgba(0, 169, 157, 0.05);
            border-radius: 50%;
            z-index: 0;
        }

        @media (max-width: 575px) {
            .cool-card {
                padding: 20px 15px;
            }

            .cool-card h5 {
                font-size: 16px;
            }

            .cool-card img {
                width: 60px;
                height: 60px;
            }
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading d-flex align-items-center">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span class="ms-2"><b id="menuTitle">হিসাব ও অর্থ বিভাগ</b></span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row" id="submenuContent">

                    @php
                        $menuItems = [
                            ['route' => 'funds', 'title' => 'ফান্ড', 'perm' => 'fund.view'],
                            ['route' => 'expense.type', 'title' => 'ব্যয়ের ধরন', 'perm' => 'expense_type.view'],
                            ['route' => 'fund.expense', 'title' => 'ব্যয়', 'perm' => 'expense.view'],
                            ['route' => 'general.fund', 'title' => 'সাধারণ জমা-খরচ', 'perm' => 'general_fund.view'],
                            ['route' => 'guraba.fund', 'title' => 'গোরাবা জমা-খরচ', 'perm' => 'guraba_fund.view'],
                            [
                                'route' => 'fund.balance.sheet',
                                'title' => 'দৈনিক জমা খরচ',
                                'perm' => 'daily_deposit_expense.view',
                            ],
                            ['route' => 'mahfil.take', 'title' => 'অনুষ্ঠান মাহফিল জমা', 'perm' => 'mahfil_taken.view'],
                            ['route' => 'mahfil', 'title' => 'অনুষ্ঠান মাহফিল খরচ', 'perm' => 'mahfil_expense.view'],
                            [
                                'route' => 'annual.accounting',
                                'title' => 'বাৎসরিক রিপোর্ট',
                                'perm' => 'annual_report.view',
                            ],
                            ['route' => 'properties', 'title' => 'সম্পদ ও আসবাবপত্র', 'perm' => 'property.view'],
                            ['route' => 'receipt.payment', 'title' => 'অডিট রিপোর্ট', 'perm' => 'audit_report.view'],
                        ];
                        $site = DB::table('settings')->first();
                        $user = auth()->user();
                    @endphp

                    @foreach ($menuItems as $item)
                        @if ($user && ($user->role_id == 1 || $user->type == 1 || $user->canPerm($item['perm'] ?? '')))
                            <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-4">
                                <div class="cool-card" onclick="window.location='{{ route($item['route']) }}'">
                                    <a href="{{ route($item['route']) }}" class="full-link"></a>
                                    <img src="{{ asset($site && $site->logo ? 'img/' . $site->logo : 'img/re.png') }}"
                                        alt="{{ $item['title'] }} Icon">
                                    <h5>{{ $item['title'] }}</h5>
                                </div>
                            </div>
                        @endif
                    @endforeach


                </div>
            </div>
        </section>
    </div>

@endsection
