@extends('dashboard.master')
@section('title', 'সিস্টেম সেটিংস')

@section('content')

<style>
    .cool-card {
        background: linear-gradient(145deg, #ffffff, #f3f3f3);
        border-radius: 16px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease-in-out;
        padding: 30px 20px;
        text-align: center;
        position: relative;
        overflow: hidden;
        border: 1px solid #eee;
        cursor: pointer;
        margin-bottom: 20px;
    }
    .cool-card:hover {
        background: linear-gradient(145deg, #f9f9f9, #ffffff);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        transform: translateY(-5px);
    }
    .cool-card a.full-link {
        position: absolute; top:0; left:0; width:100%; height:100%; z-index:1;
    }
    .cool-card h5 {
        font-weight: 600; font-size: 18px; color:#333; margin-top: 15px; position: relative; z-index:2;
    }
    .cool-card img {
        width:80px; height:80px; border-radius:50%; object-fit:cover; border:3px solid #ddd;
        padding:5px; transition: all .3s ease-in-out; z-index:2; position: relative;
    }
    .cool-card:hover img { transform: scale(1.1); border-color:#00a99d; }
    .cool-card::after {
        content:""; position:absolute; bottom:-30px; right:-30px; width:80px; height:80px;
        background: rgba(0,169,157,.05); border-radius:50%; z-index:0;
    }
    @media (max-width:575px){
        .cool-card{ padding:20px 15px; }
        .cool-card h5{ font-size:16px; }
        .cool-card img{ width:60px; height:60px; }
    }
</style>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading d-flex align-items-center">
                    <div class="page-title-icon"><i class="nav-icon fas fa-cogs"></i></div>
                    <span class="ms-2"><b id="menuTitle">সিস্টেম সেটিংস</b></span>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row" id="submenuContent">

                @php
                    // প্রতিটি আইটেমে প্রয়োজনীয় permission key যোগ করা হলো
                    $menuItems = [
                        ['route' => 'site.settings',       'title' => 'সাইট সেটিংস',        'perm' => 'site_setting.view'],
                        ['route' => 'invoice.design',       'title' => 'ইনভয়েস ডিজাইন',      'perm' => 'invoice_design.view'],
                        ['route' => 'device.setting',       'title' => 'ডিভাইস সেটিং',        'perm' => 'device_settings.view'],
                        ['route' => 'attendance.setting',   'title' => 'হাজিরা সেটিং',        'perm' => 'hajira_settings.view'],
                        ['route' => 'sms.setting',          'title' => 'এসএমএস সেটিং',       'perm' => 'sms_settings.view'],
                        ['route' => 'sms.status',           'title' => 'এসএমএস স্ট্যাটাস',     'perm' => 'sms_status.view'],
                        ['route' => 'user',                 'title' => 'ইউজার',               'perm' => 'users.view'],
                        ['route' => 'user.role.index',      'title' => 'ইউজার রোল',          'perm' => 'users_role.view'],
                        ['route' => 'admission.fee',        'title' => 'গ্লোবাল ভর্তি ফি',     'perm' => 'global_admission_fee.view'],
                        ['route' => 'student.session',      'title' => 'সেশন',                'perm' => 'session.view'],
                        ['route' => 'student.class',        'title' => 'ক্লাস',               'perm' => 'class.view'],
                        ['route' => 'subjects',             'title' => 'কিতাব',               'perm' => 'subject.view'],
                        ['route' => 'subject.assign',       'title' => 'কিতাব এসাইন',         'perm' => 'subject_assign.view'],
                        ['route' => 'data.delete',          'title' => 'ডিলিট সেটিং',         'perm' => 'delete_settings.view'],
                        ['route' => 'licence',              'title' => 'লাইসেন্স সেটিং',      'perm' => 'licence_settings.view'],
                    ];
                    $site = DB::table('settings')->first();
                    $user = auth()->user();
                @endphp

                @foreach ($menuItems as $item)
                    @if ($user && ($user->role_id == 1 || $user->type == 1 || $user->canPerm($item['perm'] ?? '')))
                        <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                            <div class="cool-card" onclick="window.location='{{ route($item['route']) }}'">
                                <a href="{{ route($item['route']) }}" class="full-link"></a>
                                <img src="{{ asset($site && $site->logo ? 'img/'.$site->logo : 'img/re.png') }}"
                                     alt="{{ $item['title'] }} Icon">
                                <h5>{{ $item['title'] }}</h5>
                            </div>
                        </div>
                    @endif
                @endforeach

            </div>
        </div>
    </section>
</div>

@endsection
