@extends('dashboard.master')
@section('title', 'শিক্ষার্থী ব্যবস্থাপনা')

@section('content')

    <style>
        .cool-card {
            background: linear-gradient(145deg, #ffffff, #f3f3f3);
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease-in-out;
            padding: 30px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
            border: 1px solid #eee;
            cursor: pointer;
            margin-bottom: 20px;
        }

        .cool-card:hover {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            transform: translateY(-5px);
        }

        .cool-card a.full-link {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .cool-card h5 {
            font-weight: 600;
            font-size: 18px;
            color: #333;
            margin-top: 15px;
            position: relative;
            z-index: 2;
        }

        .cool-card img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ddd;
            padding: 5px;
            transition: all 0.3s ease-in-out;
            z-index: 2;
            position: relative;
        }

        .cool-card:hover img {
            transform: scale(1.1);
            border-color: #00a99d;
        }

        .cool-card::after {
            content: "";
            position: absolute;
            bottom: -30px;
            right: -30px;
            width: 80px;
            height: 80px;
            background: rgba(0, 169, 157, 0.05);
            border-radius: 50%;
            z-index: 0;
        }


        .assign-label {
            position: absolute;
            top: 5px;
            left: 5px;
            background: rgba(255, 0, 0, 0.8);
            color: #fff;
            padding: 2px 6px;
            font-size: 12px;
            border-radius: 4px;
        }

        .cool-card {
            position: relative;
            padding-top: 10px;
        }


        @media (max-width: 575px) {
            .cool-card {
                padding: 20px 15px;
            }

            .cool-card h5 {
                font-size: 16px;
            }

            .cool-card img {
                width: 60px;
                height: 60px;
            }
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading d-flex align-items-center">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span class="ms-2"><b id="menuTitle">শিক্ষার্থী ব্যবস্থাপনা</b></span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row" id="submenuContent">

                    @php
                        $menuItems = [
                            ['route' => 'student.create', 'title' => 'ভর্তি', 'perm' => 'admission.view'],
                            ['route' => 'student.index', 'title' => 'শিক্ষার্থী তালিকা', 'perm' => 'students.view'],
                            [
                                'route' => 'inactive.student',
                                'title' => 'ইন‌অ্যাকটিভ শিক্ষার্থী',
                                'perm' => 'students_inactive.view',
                            ],
                            [
                                'route' => 'students.ids',
                                'title' => 'শিক্ষার্থী আইডি কার্ড',
                                'perm' => 'students_idcard.view',
                            ],
                            ['route' => 'hostel.fees', 'title' => 'শিক্ষার্থী ফি', 'perm' => 'students_fees.view'],
                            [
                                'route' => 'hostel.fees.assign',
                                'title' => 'ফি এসাইন',
                                'perm' => 'students_fees_assign.view',
                            ],
                            [
                                'route' => 'special.fees',
                                'title' => 'স্পেশাল ফি',
                                'perm' => 'students_special_fees.view',
                            ],
                            [
                                'route' => 'special.fees.assign',
                                'title' => 'স্পেশাল ফি এসাইন',
                                'perm' => 'students_special_fees_assign.view',
                            ],
                            ['route' => 'payment.list.new', 'title' => 'বেতন', 'perm' => 'students_beton.list'],
                            ['route' => 'payment.due', 'title' => 'বাকি বেতন', 'perm' => 'students_beton_due.view'],
                            ['route' => 'student.attendance', 'title' => 'হাজিরা', 'perm' => 'students_hajira.view'],
                            ['route' => 'student.leave', 'title' => 'ছুটি', 'perm' => 'students_leave.view'],
                            ['route' => 'payment.list', 'title' => 'শীঘ্রই আসছে ', 'perm' => 'payment.view'],
                            ['route' => 'admission.due', 'title' => 'ভর্তি বাকি', 'perm' => 'admission_due.view'] // adjust as needed
                        ];
                        $site = DB::table('settings')->first();
                    @endphp

                    @foreach ($menuItems as $item)
                        @if (auth()->user()->role_id == 1 || auth()->user()->type == 1 || auth()->user()->canPerm($item['perm']))
                            <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="cool-card" onclick="window.location='{{ route($item['route']) }}'">
                                    <a href="{{ route($item['route']) }}" class="full-link"></a>

                                    <img src="{{ asset($site && $site->logo ? 'img/' . $site->logo : 'img/re.png') }}"
                                        alt="{{ $item['title'] }} Icon">

                                    <h5>{{ $item['title'] }}</h5>

                                    {{-- extra label গুলো --}}
                                    @if (Str::contains($item['title'], 'অনাবাসিক ফি এসাইন'))
                                        <div class="text-white"
                                            style="margin-top:4px;font-size:13px;background:rgb(70,185,70);border-radius:20px">
                                            নির্ধারিত ক্লাসের সকল অনাবাসিক শিক্ষার্থীদের জন্য।
                                        </div>
                                    @elseif (Str::contains($item['title'], 'আবাসিক ফি এসাইন'))
                                        <div class="text-white"
                                            style="margin-top:4px;font-size:13px;background:rgb(70,185,70);border-radius:20px">
                                            নির্ধারিত ক্লাসের সকল আবাসিক শিক্ষার্থীদের জন্য।
                                        </div>
                                    @elseif (Str::contains($item['title'], 'একাডেমিক ফি এসাইন'))
                                        <div class="text-white"
                                            style="margin-top:4px;font-size:13px;background:rgb(70,185,70);border-radius:20px">
                                            নির্ধারিত ক্লাসের সকল আবাসিক ও অনাবাসিক শিক্ষার্থীর জন্য।
                                        </div>
                                    @elseif (Str::contains($item['title'], 'অন্যান্য ফি এসাইন'))
                                        <div class="text-white"
                                            style="margin-top:4px;font-size:13px;background:rgb(70,185,70);border-radius:20px">
                                            নির্ধারিত ক্লাসের সকল আবাসিক ও অনাবাসিক শিক্ষার্থীর জন্য।
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif
                    @endforeach


                </div>
            </div>
        </section>
    </div>

@endsection
