@extends('dashboard.master')
@section('title', 'Edit Money Receipt')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .bangla{
        font-weight: 0;
        font-size:15px;
    }
    .value{
        margin-left: 30px;
        font-weight: 1;
    }
</style>
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Money Receipt</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('money-receipt.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="receipt_no">রিসিট নং/Receipt No<span class="text-red">*</span></label>
									<input type="text" name="receipt_no" id="receipt_no" value="{{ $receiptNo }}" class="form-control" placeholder="receipt no" readonly>

                                    <input type="hidden" name="student_id" value="{{ $data->student_id }}">

									@error('receipt_no ')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="form_no"><span class="bangla">নিবন্ধন নং</span>/Register No <span class="text-red">*</span></label>
									<input type="text" name="register_no" id="register_no" value="{{ $data->register_no }}" class="form-control datepicker @error('form_no') is-invalid @enderror" readonly>

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name"><span class="bangla">নাম</span>/Student Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" readonly>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="department"><span class="bangla">ক্লাস</span>/Class<span class="text-red">*</span></label>

									<input type="text" id="department_id" value="{{ $data->students->departments->department_name }}" class="form-control @error('department_id') is-invalid @enderror" readonly>

									@error('department_id')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>
									<input type="text" name="date" id="date" value="{{ $data->date }}" class="form-control" placeholder="Enter date" required>

									@error('date ')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="month"><span class="bangla">মাস</span>/Month <span class="text-red">*</span></label>
									<input type="month" name="month" id="month" value="{{ $data->month }}" class="form-control datepicker @error('month') is-invalid @enderror" placeholder="Enter month" required>

									@error('month')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span class="text-red">*</span></label>
									<input type="text" name="amount" id="amount" value="{{ $amount }}" class="form-control @error('amount') is-invalid @enderror" placeholder="Enter amount" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>


							<div class="col-sm-8">
								<div class="form-group">
									<label for="in_word"><span class="bangla">কথায়</span>/In Word <span class="text-red">*</span></label>

                                    {{-- <textarea rows="3" name="in_word" id="in_word" class="form-control" placeholder="Write in word" required>{!! $data->in_word !!}</textarea> --}}

                                    <input type="text" name="in_word" id="in_word" value="{{ $data->in_word }}" class="form-control @error('in_word') is-invalid @enderror" placeholder="কথায় লিখুন" >

									@error('in_word')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="received_purpose"><span class="bangla">বাবদ</span>/On Account Of<span class="text-red">*</span></label>
									<textarea rows="2" name="received_purpose" id="received_purpose" class="form-control" placeholder="Write On Account Of">{!! $data->received_purpose !!}</textarea>

									@error('received_purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							{{-- <div class="col-sm-12">
								<div class="form-group">
									<label for="address"><span class="bangla">ঠিকানা</span>/Address<span class="text-red">*</span></label>
									<textarea rows="3" name="address" id="address" class="form-control" placeholder="Write address">{!! $data->address !!}</textarea>

									@error('address')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div> --}}

						</div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

    <script>
       $(function () {
           $('#date').datepicker({
               dateFormat: 'dd MM yy'
           });
       });
       </script>
@endpush
@endsection
